/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.apis.dtos;

import cn.hutool.core.date.DateTime;
import cn.myapps.common.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.runtime.apis.dtos.ChangeLogTableMapDto;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class SyncChangeLogTableDto {
    private final String tableName;
    private final boolean isOnline;
    private final String config;
    private final String target_config;
    private final String url;
    private final String appId;
    private final String name;
    private final String filter;
    private final Timestamp refreshTime;
    private Collection<ChangeLogTableMapDto> tableMaps;
    private String _mapKey;

    public String getDisplayName() {
        return String.format("%s(%s)", this.getName(), this.getTableName());
    }

    public SyncChangeLogTableDto(String name, String tableName, String filter, String appId, String config, String target_config, String url, boolean isOnline) {
        this.name = name;
        this.tableName = tableName;
        this.filter = filter;
        this.isOnline = isOnline;
        this.config = config;
        this.target_config = target_config;
        this.url = url;
        this.appId = appId;
        this.refreshTime = Timestamp.from(Instant.now());
    }

    public String getSql(String regionId, DateTime fromTime, DateTime endTime) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)endTime);
        Date expectedEndTime = calendar.getTime();
        if (!StringUtil.isBlank((String)regionId)) {
            if (this.getTableName().contains("sync_employee_view")) {
                return String.format("SELECT * FROM %s where (LASTMODIFIED>='%s' and LASTMODIFIED<='%s') %s and  domain_id IN ( SELECT id FROM obpm2.tenant_organizations \n                WHERE industry_code='01' and supervise_region_code like '%s') order by LASTMODIFIED asc ", this.getTableName(), dateFormat.format((Date)fromTime), dateFormat.format(expectedEndTime), StringUtils.hasLength((String)this.getFilter()) ? this.getFilter() : "", regionId.concat("%"));
            }
            return String.format("SELECT * FROM %s where (LASTMODIFIED>='%s' and LASTMODIFIED<'%s') %s and  domainid IN ( SELECT id FROM obpm2.tenant_organizations \n                WHERE industry_code='01' and supervise_region_code like '%s') order by LASTMODIFIED asc ", this.getTableName(), dateFormat.format((Date)fromTime), dateFormat.format(expectedEndTime), StringUtils.hasLength((String)this.getFilter()) ? this.getFilter() : "", regionId.concat("%"));
        }
        return String.format("SELECT * FROM %s where (LASTMODIFIED>='%s' and LASTMODIFIED<'%s') %s order by LASTMODIFIED asc ", this.getTableName(), dateFormat.format((Date)fromTime), dateFormat.format(expectedEndTime), StringUtils.hasLength((String)this.getFilter()) ? this.getFilter() : "");
    }

    public String getMapKey() {
        if (!StringUtils.hasLength((String)this._mapKey) && StringUtils.hasLength((String)this.getConfig())) {
            this._mapKey = (String)JSON.parseObject((String)this.getConfig()).get((Object)"mapKey");
        }
        return this._mapKey;
    }

    public void assignTemplates(Collection<ChangeLogTableMapDto> tableMaps) {
        this.tableMaps = tableMaps;
    }

    public static SyncChangeLogTableDto create(String name, String tableName, String filter, String appId, String config, String target_config, String url, boolean is_online) {
        return new SyncChangeLogTableDto(name, tableName, filter, appId, config, target_config, url, is_online);
    }

    public String toString() {
        return String.format("appId=%s;name=%s;tableName=%s;is_online=%s;", this.getAppId(), this.getName(), this.getTableName(), this.isOnline());
    }

    public Collection<String> getTemplates() {
        if (CollectionUtils.isEmpty(this.getTableMaps())) {
            return Collections.emptyList();
        }
        return this.getTableMaps().stream().map(ii -> ii.getTemplate()).collect(Collectors.toList());
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isOnline() {
        return this.isOnline;
    }

    public String getConfig() {
        return this.config;
    }

    public String getTarget_config() {
        return this.target_config;
    }

    public String getUrl() {
        return this.url;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getName() {
        return this.name;
    }

    public String getFilter() {
        return this.filter;
    }

    public Timestamp getRefreshTime() {
        return this.refreshTime;
    }

    public Collection<ChangeLogTableMapDto> getTableMaps() {
        return this.tableMaps;
    }
}

