/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.apis.dtos;

import com.bcxin.runtime.apis.configs.RegionConfig;
import com.bcxin.runtime.apis.dtos.SyncChangeLogTableDto;
import com.bcxin.runtime.apis.requests.DownChangelogRequest;
import com.bcxin.runtime.domain.repositories.syncs.components.impls.SqlParserAbstract;
import com.bcxin.saas.core.utils.ExceptionUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ChangeLogContext {
    public static final String ISTMP_COLUMN = "ISTMP";
    private final SyncChangeLogTableDto table;
    private final DownChangelogRequest changelogRequest;
    private final RegionConfig.RegionConfigItem selectedRegionConfigItem;
    private final Collection<String> sqlTemplates;

    private ChangeLogContext(SyncChangeLogTableDto table, Collection<String> sqlTemplates, DownChangelogRequest changelogRequest, RegionConfig.RegionConfigItem selectedRegionConfigItem) {
        this.table = table;
        this.changelogRequest = changelogRequest;
        this.selectedRegionConfigItem = selectedRegionConfigItem;
        this.sqlTemplates = sqlTemplates;
    }

    public static ChangeLogContext create(SyncChangeLogTableDto table, Collection<String> sqlTemplates, DownChangelogRequest changelogRequest, RegionConfig.RegionConfigItem selectedRegionConfigItem) {
        return new ChangeLogContext(table, sqlTemplates, changelogRequest, selectedRegionConfigItem);
    }

    public Map<String, Object> getParams(Map<String, Object> dt) {
        if (dt == null) {
            return Collections.emptyMap();
        }
        try {
            Optional<String> isTmpColumnOptional;
            Optional<String> keyOptional;
            String kValue;
            Collection defaultMappingColumns = SqlParserAbstract.getTDocumentMapSnapshotTemplate().getColumns();
            if (CollectionUtils.isEmpty((Collection)defaultMappingColumns)) {
                for (Object col : defaultMappingColumns) {
                    if (dt.containsKey(col.getFieldName())) continue;
                    dt.put(col.getFieldName(), col.getFixedValue() == null ? col.getDefaultValue() : col.getFixedValue());
                }
            }
            if (this.selectedRegionConfigItem == null) {
                dt.put("dynamic_domain_id", null);
            } else {
                dt.put("dynamic_domain_id", this.selectedRegionConfigItem.getDomainId());
                Map<String, String> dbNameMaps = this.selectedRegionConfigItem.getDbMaps();
                if (!CollectionUtils.isEmpty(dbNameMaps)) {
                    for (String key : dbNameMaps.keySet()) {
                        kValue = dbNameMaps.get(key);
                        if (!StringUtils.hasLength((String)kValue)) continue;
                        dt.put(String.format("dynamic_%s", key), kValue);
                    }
                }
            }
            if ("public".equalsIgnoreCase(this.selectedRegionConfigItem.getPrefixId()) && (keyOptional = dt.keySet().stream().filter(ii -> ii.equalsIgnoreCase("domainId")).findFirst()).isPresent()) {
                dt.put("dynamic_domain_id", dt.get(keyOptional.get()));
            }
            if ((isTmpColumnOptional = dt.keySet().stream().filter(ii -> ISTMP_COLUMN.equalsIgnoreCase((String)ii)).findFirst()).isPresent()) {
                Object value = dt.get(isTmpColumnOptional.get());
                value = value != null && ("true".equalsIgnoreCase(String.valueOf(value)) || "1".equalsIgnoreCase(String.valueOf(value))) ? "1" : "0";
                dt.put(isTmpColumnOptional.get(), value);
            }
            if (!CollectionUtils.isEmpty(this.changelogRequest.getDynamicParameterMaps())) {
                for (String key : this.changelogRequest.getDynamicParameterMaps().keySet()) {
                    kValue = this.changelogRequest.getDynamicParameterMaps().get(key);
                    dt.put(String.format("dynamic_%s", key), kValue);
                }
            }
        }
        catch (Exception ex) {
            System.err.println(String.format("getParams\u7684\u65f6\u5019\u53d1\u751f\u5f02\u5e38:%s", ExceptionUtils.getStackMessage((Throwable)ex)));
        }
        return dt;
    }

    public SyncChangeLogTableDto getTable() {
        return this.table;
    }

    public DownChangelogRequest getChangelogRequest() {
        return this.changelogRequest;
    }

    public RegionConfig.RegionConfigItem getSelectedRegionConfigItem() {
        return this.selectedRegionConfigItem;
    }

    public Collection<String> getSqlTemplates() {
        return this.sqlTemplates;
    }
}

