/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.apis.controllers;

import cn.myapps.common.auth.IUser;
import com.bcxin.runtime.apis.controllers.ControllerAbstract;
import com.bcxin.saas.core.exceptions.SaasNofoundException;
import com.bcxin.saas.domains.dtos.RbacEmployeePermitAppDTO;
import com.bcxin.saas.domains.dtos.RbacQueryDTO;
import com.bcxin.saas.domains.readers.RbacDbReader;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/runtime/currentuser"})
public class CurrentUserController
extends ControllerAbstract {
    private final RbacDbReader rbacDbReader;

    public CurrentUserController(RbacDbReader rbacDbReader) {
        this.rbacDbReader = rbacDbReader;
    }

    @GetMapping(value={"/rbac/apps"})
    public ResponseEntity getPermitApps(@RequestParam(value="isMobile") boolean isMobile) throws Exception {
        try {
            IUser user = this.getWebUser();
            RbacQueryDTO rbacQueryDTO = RbacQueryDTO.create((String)user.getId(), (String)user.getDomainid(), (boolean)user.isDomainAdmin(), (boolean)isMobile, null);
            RbacEmployeePermitAppDTO permitAppDTO = this.rbacDbReader.getPermitApps(rbacQueryDTO);
            return ResponseEntity.ok((Object)permitAppDTO);
        }
        catch (Exception ex) {
            if (ex instanceof SaasNofoundException) {
                return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)ex.getMessage());
            }
            throw ex;
        }
    }
}

