/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.apis.controllers;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.myapps.authtime.common.dao.PersistenceUtils;
import cn.myapps.common.Environment;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.datasource.DataSource;
import cn.myapps.common.util.PropertiesConfig;
import cn.myapps.designtime.common.cache.DesignTimeSerializableCache;
import cn.myapps.util.file.ZipUtil;
import com.bcxin.runtime.apis.components.MappingSqlValueTranslator;
import com.bcxin.runtime.apis.configs.RegionConfig;
import com.bcxin.runtime.apis.controllers.SecurityControllerAbstract;
import com.bcxin.runtime.apis.dtos.ChangeLogContext;
import com.bcxin.runtime.apis.dtos.ChangeLogDataResult;
import com.bcxin.runtime.apis.dtos.ChangeLogTableMapDto;
import com.bcxin.runtime.apis.dtos.SyncChangeLogTableDto;
import com.bcxin.runtime.apis.dtos.TranslateSqlResult;
import com.bcxin.runtime.apis.exceptions.ChangeLogBadException;
import com.bcxin.runtime.apis.requests.DownChangelogRequest;
import com.bcxin.runtime.apis.responses.ChangeLogResponse;
import com.bcxin.runtime.apis.responses.DownloadChangelogResponse;
import com.bcxin.runtime.domain.constants.FieldNames;
import com.bcxin.saas.core.components.JsonProvider;
import com.bcxin.saas.core.exceptions.SaasBadException;
import com.bcxin.saas.core.exceptions.SaasForbidException;
import com.bcxin.saas.core.exceptions.SaasNofoundException;
import com.bcxin.saas.core.utils.CompleteFurtherUtils;
import com.bcxin.saas.core.utils.ExceptionUtils;
import com.bcxin.spring.adpater.config.SaasSpringConfig;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSetMetaData;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v3/extends/change-logs"})
public class ChangelogController
extends SecurityControllerAbstract {
    private static final Logger logger = LoggerFactory.getLogger(ChangelogController.class);
    private final JdbcTemplate jdbcTemplate;
    private final MappingSqlValueTranslator mappingSqlValueTranslator;
    private final PropertiesConfig propertiesConfig;
    private final RegionConfig regionConfig;
    private final JsonProvider jsonProvider;
    private final String INSERT_CHANGE_LOG = "INSERT INTO sync_change_logs(id,name,path,total,current,params)values(?,?,?,?,?,?)";
    private final String UPDATE_CHANGE_LOG = "UPDATE sync_change_logs SET current=current+?,result=?,last_updated_time=CURRENT_TIMESTAMP WHERE ID=?";
    private final String COMPLETE_UPDATE_CHANGE_LOG = "UPDATE sync_change_logs SET current=?,result=?,last_updated_time=CURRENT_TIMESTAMP WHERE ID=?";
    private final String DELETE_CHANGE_LOG = "delete from sync_change_logs where id=?";
    private final String GET_CHANGE_LOG = "select id,name,path,createdTime,total,current,result,last_updated_time from sync_change_logs where id=?";
    private final String GET_ALL_CHANGE_LOG = "select id,name,path,createdTime,total,current,result from sync_change_logs order by createdTime desc limit 30 ";
    private final String LOG_OUTPUT_ZIP_DIRECTORY = "/uploads/export_cdc/%s";
    private final String SYNC_CHANGE_LOG_SQL_TEMPLATE = "select app.app_id,f.name,sf.filter, f.table_name,sf.is_online,sf.config,st.config as target_config,st.url\nfrom meta_apps app join meta_forms f on app.id=f.application_meta_id\njoin sync_meta_forms sf on f.id=sf.form_meta_id\njoin sync_meta_form_targets st on st.id=sf.target_meta_id\nwhere sf.is_online=1 and st.url like '%v2/ftp%' ";
    private final String SYNC_DYNAMIC_DATA_MAP_TEMPLATES = "SELECT template,mapkey,region FROM dynamic_data_map_templates";
    private static Collection<ChangeLogTableMapDto> _changeLogTableMaps;
    private static Collection<SyncChangeLogTableDto> _syncChangeLogTables;
    private static final Map<String, DataSource> _selectedDataSourceByAppId;
    private static final Map<String, JdbcTemplate> _selectedJdbcTemplateByDsId;

    public ChangelogController(JdbcTemplate jdbcTemplate, MappingSqlValueTranslator mappingSqlValueTranslator, PropertiesConfig propertiesConfig, RegionConfig regionConfig, JsonProvider jsonProvider) {
        this.jdbcTemplate = jdbcTemplate;
        this.mappingSqlValueTranslator = mappingSqlValueTranslator;
        this.propertiesConfig = propertiesConfig;
        this.regionConfig = regionConfig;
        this.jsonProvider = jsonProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping
    @Async
    public CompletableFuture<ResponseEntity<DownloadChangelogResponse>> post(@RequestBody DownChangelogRequest request, HttpServletRequest servletRequest) throws Exception {
        ConcurrentHashMap<String, String> detailContainer = new ConcurrentHashMap<String, String>();
        if (!DesignTimeSerializableCache.isReady()) {
            return CompletableFuture.completedFuture(ResponseEntity.badRequest().body((Object)DownloadChangelogResponse.create(null, null, null, null, "\u7cfb\u7edf\u542f\u52a8\u4e2d, \u8bf7\u7a0d\u540e\u518d\u8bd5...")));
        }
        SaasSpringConfig.CustomSystemErrorPrintStream.enableForPackage();
        try {
            CompletableFuture<ResponseEntity<DownloadChangelogResponse>> timeCheckResult;
            request.validate(servletRequest);
            if (request.getNeedServerTimeCheck().booleanValue() && (timeCheckResult = this.validateEndTime(request)) != null) {
                CompletableFuture<ResponseEntity<DownloadChangelogResponse>> completableFuture = timeCheckResult;
                return completableFuture;
            }
            RegionConfig.RegionConfigItem regionConfigItem = this.regionConfig.getSelectedRegionConfigItem(request.getRegionCode());
            if (regionConfigItem == null) {
                throw new SaasForbidException(String.format("\u627e\u4e0d\u5230%s\u5bf9\u5e94\u7684\u533a\u57df\u4fe1\u606f", request.getRegionCode()));
            }
            SimpleDateFormat yyMMddDateFormat = new SimpleDateFormat("yyyyMMdd");
            String rootDirName = String.format("cdc_%s_%s", request.getRegionCode(), yyMMddDateFormat.format((Date)request.getFromTime()));
            Long requestId = Long.parseLong(new SimpleDateFormat("yyyyMMddhhmmssSSS").format(new Date()));
            String relativePath = String.format("/uploads/export_cdc/%s", requestId).concat(File.separator).concat(rootDirName);
            String rootPath = this.propertiesConfig.getStorageroot().concat(File.separator).concat(relativePath);
            Collection tables = this.getChangelogTables(request).stream().filter(ii -> {
                if (CollectionUtils.isEmpty(request.getTables())) {
                    return true;
                }
                return request.matched((SyncChangeLogTableDto)ii);
            }).collect(Collectors.toList());
            String selectedNames = "\u6240\u6709";
            if (!CollectionUtils.isEmpty(request.getTables())) {
                selectedNames = tables.stream().map(ii -> ii.getName()).limit(10L).collect(Collectors.joining("-"));
                if (tables.size() > 10) {
                    selectedNames = selectedNames + "...";
                }
            }
            try {
                Object[] param = new Object[]{requestId, String.format("{rn:\"%s\",ft:\"%s\",et:\"%s\",sn:\"%s\"}", request.getRegionName(), yyMMddDateFormat.format((Date)request.getFromTime()), yyMMddDateFormat.format((Date)request.getEndTime()), selectedNames), relativePath, tables.size(), 0, this.jsonProvider.getJson((Object)request)};
                this.jdbcTemplate.update("INSERT INTO sync_change_logs(id,name,path,total,current,params)values(?,?,?,?,?,?)", param);
            }
            catch (Exception ex) {
                logger.error("SQL\u6267\u884cInsert\u53d1\u751f\u5f02\u5e38:{};path={}", new Object[]{"INSERT INTO sync_change_logs(id,name,path,total,current,params)values(?,?,?,?,?,?)", relativePath, ex});
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            Executors.newSingleThreadExecutor().execute(() -> {
                try {
                    SaasSpringConfig.CustomSystemErrorPrintStream.enableForPackage();
                    this.executeCdcCapture(regionConfigItem, requestId, tables, request, servletRequest, rootPath, rootDirName, yyMMddDateFormat);
                }
                catch (Exception e) {
                    logger.error("\u6267\u884c\u5dee\u5f02\u5316\u65e5\u5fd7\u5f02\u5e38", (Throwable)e);
                    throw new SaasBadException("\u6267\u884c\u5dee\u5f02\u5316\u65e5\u5fd7\u5f02\u5e38", e);
                }
                finally {
                    countDownLatch.countDown();
                }
            });
            countDownLatch.await(30L, TimeUnit.SECONDS);
            DownloadChangelogResponse downloadChangelogResponse = DownloadChangelogResponse.create(String.format("%s/%s", this.propertiesConfig.getStorageroot(), relativePath), relativePath, detailContainer, null, "\u7cfb\u7edf\u53ea\u7b49\u5f8530\u79d2, \u5176\u4ed6\u7b49\u5f85\u7cfb\u7edf\u6267\u884c\u7ed3\u679c;\u51e0\u5206\u949f\u540e\u8fdb\u884c\u4e0b\u8f7d");
            CompletableFuture<ResponseEntity<DownloadChangelogResponse>> completableFuture = CompletableFuture.completedFuture(ResponseEntity.ok((Object)downloadChangelogResponse));
            return completableFuture;
        }
        catch (Exception ex) {
            CompletableFuture<ResponseEntity<DownloadChangelogResponse>> completableFuture = CompletableFuture.completedFuture(ResponseEntity.badRequest().body((Object)DownloadChangelogResponse.create("\u5f02\u5e38", "\u5f02\u5e38", detailContainer, Collections.singleton(ex), ex.toString())));
            return completableFuture;
        }
        finally {
            SaasSpringConfig.CustomSystemErrorPrintStream.disable();
        }
    }

    @GetMapping(value={"/download/{zipId}"})
    public void download(@PathVariable(value="zipId") String zipId, HttpServletResponse response) throws Exception {
        String realPath = this.propertiesConfig.getStorageroot().concat(String.format("/uploads/export_cdc/%s", zipId));
        File dir = new File(realPath);
        if (!dir.exists()) {
            response.setStatus(HttpStatus.NOT_FOUND.value());
            return;
        }
        if (!this.isChangeLogsFinished(zipId)) {
            response.setStatus(HttpStatus.INSUFFICIENT_STORAGE.value());
            return;
        }
        Collection allFilePathes = Arrays.stream(dir.listFiles()).map(ii -> ii.getAbsolutePath()).collect(Collectors.toList());
        if (!allFilePathes.stream().anyMatch(ii -> ii.endsWith(".zip"))) {
            String[] pathes = allFilePathes.stream().filter(ii -> !ii.endsWith(".zip")).flatMap(ii -> {
                File selectedFile = new File((String)ii);
                if (selectedFile.isDirectory()) {
                    return Arrays.stream(selectedFile.listFiles()).map(fi -> fi.getAbsolutePath());
                }
                return Stream.of(ii);
            }).collect(Collectors.toList()).toArray(new String[0]);
            ZipUtil.compressFiles((String)zipId, (String[])pathes, (String)realPath);
        }
        this.responseWithFile(zipId, realPath, response);
    }

    @GetMapping
    @Async
    public CompletableFuture<ResponseEntity<Collection<ChangeLogResponse>>> getAll() {
        List data = this.jdbcTemplate.query("select id,name,path,createdTime,total,current,result from sync_change_logs order by createdTime desc limit 30 ", (rs, rnum) -> {
            String id = rs.getString("id");
            String name = rs.getString("name");
            String path = rs.getString("path");
            Long total = rs.getLong("total");
            Long current = rs.getLong("current");
            String result = rs.getString("result");
            Timestamp datetime = rs.getTimestamp("createdTime");
            return ChangeLogResponse.create(id, name, path, total, current, result, datetime);
        });
        return CompletableFuture.completedFuture(ResponseEntity.ok((Object)data));
    }

    @GetMapping(value={"/{id}"})
    @Async
    public CompletableFuture<ResponseEntity<ChangeLogResponse>> get(@PathVariable String id) {
        Object[] param = new Object[]{id};
        ChangeLogResponse logResponse = (ChangeLogResponse)this.jdbcTemplate.queryForObject("select id,name,path,createdTime,total,current,result,last_updated_time from sync_change_logs where id=?", param, (rs, rNum) -> {
            String rid = rs.getString("id");
            String name = rs.getString("name");
            String path = rs.getString("path");
            Long total = rs.getLong("total");
            Long current = rs.getLong("current");
            String result = rs.getString("result");
            Timestamp datetime = rs.getTimestamp("createdTime");
            return ChangeLogResponse.create(id, name, path, total, current, result, datetime);
        });
        return CompletableFuture.completedFuture(ResponseEntity.ok((Object)logResponse));
    }

    @DeleteMapping(value={"/{id}"})
    @Async
    public CompletableFuture<ResponseEntity> delete(@PathVariable String id) throws ExecutionException, InterruptedException {
        Object[] param = new Object[]{id};
        CompletableFuture<ResponseEntity<ChangeLogResponse>> completableFuture = this.get(id);
        ChangeLogResponse body = (ChangeLogResponse)completableFuture.get().getBody();
        if (body == null) {
            return CompletableFuture.completedFuture(ResponseEntity.notFound().build());
        }
        if (FileUtil.exist((String)body.getPath())) {
            FileUtil.del((String)body.getPath());
        }
        this.jdbcTemplate.update("delete from sync_change_logs where id=?", param);
        return CompletableFuture.completedFuture(ResponseEntity.ok((Object)"\u5220\u9664\u6210\u529f"));
    }

    @GetMapping(value={"/template/download"})
    public void download(HttpServletResponse response) throws Exception {
        Collection<SyncChangeLogTableDto> changeLogTables = this.getChangelogTables(new DownChangelogRequest());
        Long requestId = new Date().getTime();
        String rootPath = String.format("%s/uploads/templates/%s", this.propertiesConfig.getStorageroot(), requestId);
        HashSet templateSqlPaths = new HashSet();
        changeLogTables.forEach(tb -> {
            if (!tb.getTableName().toLowerCase(Locale.ROOT).startsWith("tlk")) {
                logger.error("\u5ffd\u7565\u8be5\u8868\u7684\u914d\u7f6e\u4fe1\u606f:{}", tb);
                return;
            }
            String templateSQL = String.format("select column_name from information_schema.`COLUMNS` col where table_name='%s'", tb.getTableName());
            List columnNames = this.jdbcTemplate.query(templateSQL, (rs, rowNum) -> rs.getString("column_name"));
            StringBuilder sb = new StringBuilder(String.format("insert into %s(", tb.getTableName()));
            StringBuilder colsName = new StringBuilder();
            StringBuilder colsValue = new StringBuilder();
            StringBuilder colsValueUpdate = new StringBuilder();
            for (String col : columnNames.stream().distinct().collect(Collectors.toList())) {
                if (colsName.length() > 0) {
                    colsName.append(",");
                    colsValue.append(",");
                }
                colsName.append(col);
                String colValue = col;
                if ("domainid".equalsIgnoreCase(colValue)) {
                    colValue = "dynamic_domain_id";
                } else if ("item_domain_id".equalsIgnoreCase(colValue)) {
                    colValue = "domainid";
                }
                colsValue.append(String.format("'#{%s}'", colValue));
                String colIgnore = col.toLowerCase(Locale.ROOT);
                if ((colIgnore.equalsIgnoreCase("id") || !colIgnore.startsWith("item_")) && !col.equalsIgnoreCase("LASTMODIFIED")) continue;
                if (colsValueUpdate.length() > 0) {
                    colsValueUpdate.append(",");
                }
                colsValueUpdate.append(String.format("%s='#{%s}'", col, col));
            }
            sb.append((CharSequence)colsName);
            sb.append(") values(");
            sb.append((CharSequence)colsValue);
            if (StringUtils.hasLength((CharSequence)colsValueUpdate)) {
                sb.append(String.format(") ON DUPLICATE KEY UPDATE %s;", colsValueUpdate));
            } else {
                sb.append(") ");
            }
            String path = String.format("%s/%s.sql", rootPath, tb.getTableName());
            FileUtil.writeUtf8String((String)sb.toString(), (String)path);
            templateSqlPaths.add(path);
        });
        ZipUtil.compressFiles((String)"\u589e\u91cf\u6570\u636e\u6a21\u677f", (String[])templateSqlPaths.toArray(new String[0]), (String)rootPath);
        this.responseWithFile("\u589e\u91cf\u6570\u636e\u6a21\u677f:" + requestId, rootPath, response);
    }

    @GetMapping(value={"/meta/tables"})
    public ResponseEntity<Collection<SyncChangeLogTableDto>> getAllTables() {
        Collection<SyncChangeLogTableDto> tables = this.getChangelogTables(new DownChangelogRequest());
        return ResponseEntity.ok(tables.stream().map(ii -> {
            String formattedTableName = DownChangelogRequest.getAppTableName(ii.getAppId(), ii.getTableName());
            return SyncChangeLogTableDto.create(ii.getName(), formattedTableName, ii.getFilter(), ii.getAppId(), ii.getConfig(), ii.getTarget_config(), ii.getUrl(), ii.isOnline());
        }).collect(Collectors.toList()));
    }

    @PostMapping(value={"/meta/tables/clear"})
    public ResponseEntity clearTables() {
        Collection<ChangeLogTableMapDto> x = _changeLogTableMaps;
        if (_changeLogTableMaps != null) {
            _changeLogTableMaps.clear();
        }
        if (_syncChangeLogTables != null) {
            _syncChangeLogTables.clear();
        }
        return ResponseEntity.ok(x);
    }

    @GetMapping(value={"/download/error/{id}"})
    public ResponseEntity getErrorTables(@PathVariable String id) {
        Object[] param = new Object[]{id};
        Map resultMap = this.jdbcTemplate.queryForMap("select id,name,path,createdTime,total,current,result,last_updated_time from sync_change_logs where id=?", param);
        String result = (String)resultMap.get("result");
        Pattern pattern = Pattern.compile("Error for table=([^\\(]+)");
        Matcher matcher = pattern.matcher(result);
        ArrayList<String> tables = new ArrayList<String>();
        while (matcher.find()) {
            tables.add(matcher.group(1));
        }
        return ResponseEntity.ok(tables);
    }

    private void executeCdcCapture(RegionConfig.RegionConfigItem regionConfigItem, Long requestId, Collection<SyncChangeLogTableDto> tables, DownChangelogRequest request, HttpServletRequest servletRequest, String rootPath, String rootDirName, SimpleDateFormat yyMMddDateFormat) throws Exception {
        logger.error("begin to execute executeCdcCapture");
        ConcurrentHashMap detailContainer = new ConcurrentHashMap();
        StopWatch watch = new StopWatch();
        ArrayList changeLogBadExceptions = new ArrayList();
        List storedPaths = Collections.synchronizedList(new ArrayList());
        watch.start("\u5f00\u59cb\u6293\u53d6\u6570\u636e\u8868\u7684\u53d8\u66f4\u9700\u4fe1\u606f");
        AtomicInteger successAtomicCount = new AtomicInteger(0);
        AtomicInteger processedAtomicIndex = new AtomicInteger(0);
        StringBuffer processedMessage = new StringBuffer();
        StringBuffer errorMessage = new StringBuffer();
        AtomicInteger processedTotalCount = new AtomicInteger(0);
        AtomicInteger executeIndex = new AtomicInteger(0);
        CompleteFurtherUtils.executeWait(tables, tb -> {
            block24: {
                SaasSpringConfig.CustomSystemErrorPrintStream.enableForPackage();
                Collection<Map<String, Object>> data = null;
                StopWatch subStopWatch = new StopWatch();
                int totalCount = 0;
                StringBuilder sqlBuilderTracking = new StringBuilder();
                int skipOffset = 0;
                subStopWatch.start(String.format("\u5f00\u59cb\u83b7\u53d6\u6a21\u677f\u4fe1\u606f:%s", tb.getTableName()));
                SyncChangeLogTableDto table = tb;
                Collection<String> sqlTemplate = table.getTemplates();
                subStopWatch.stop();
                subStopWatch.start(String.format("\u5f00\u59cb\u83b7\u53d6\u6a21\u677f\u4fe1\u606f:%s", tb.getTableName()));
                if (CollectionUtils.isEmpty(sqlTemplate)) {
                    throw new SaasBadException(String.format("\u6570\u636e(mapKey=%s)\u627e\u4e0d\u5230\u5bf9\u5e94\u6a21\u677f\u4fe1\u606f", table.getMapKey()));
                }
                subStopWatch.stop();
                subStopWatch.start(String.format("\u5f00\u59cb\u6267\u884c\u6570\u636e\u6293\u53d6:%s", tb.getTableName()));
                Collection<String> paths = null;
                boolean isContinue = false;
                do {
                    block23: {
                        try {
                            ChangeLogDataResult result = this.getChangelogData((SyncChangeLogTableDto)tb, skipOffset, request);
                            data = result.getData();
                            skipOffset += result.getCountOfData();
                            totalCount += data.size();
                            isContinue = !CollectionUtils.isEmpty(data) && result.getCountOfData() > 0;
                            sqlBuilderTracking.append((CharSequence)result.getTrackingBuilder());
                            detailContainer.put(tb.getTableName(), String.format("\u603b\u6570\u91cf:%s", data.size()));
                            if (CollectionUtils.isEmpty(data)) break block23;
                            Collection<TranslateSqlResult> sqls = this.translate2Sql(ChangeLogContext.create(tb, sqlTemplate, request, regionConfigItem), data);
                            try {
                                if (sqls.size() != data.size()) {
                                    processedMessage.append(String.format("\u544a\u8b66:%s-\u89e3\u6790\u7684\u6570\u636e\u4e0d\u4e00\u81f4(%s!=%s)", tb.getTableName(), sqls.size(), data.size()));
                                    System.err.println(String.format("\u6b63\u5728\u6267\u884c\u8868=%s;\u89e3\u6790\u6570\u636e\u4e0d\u4e00\u81f4(%s!=%s)", tb.getTableName(), sqls.size(), data.size()));
                                }
                            }
                            catch (Exception ex) {
                                processedMessage.append(String.format("\u544a\u8b66:%s-\u89e3\u6790\u7684\u6570\u636e\u4e0d\u4e00\u81f4\u5f02\u5e38:%s", tb.getTableName(), ex.getMessage()));
                            }
                            processedTotalCount.addAndGet(data.size());
                            paths = this.store((SyncChangeLogTableDto)tb, rootPath, skipOffset, sqls);
                            if (!CollectionUtils.isEmpty(paths)) {
                                storedPaths.addAll(paths);
                            }
                        }
                        catch (Throwable throwable) {
                            System.err.println(String.format("\u6b63\u5728\u6267\u884c\u8868=%s;\u6570\u636e=%s, skipOffset=%s,totalCount=%s;\u662f\u5426\u7ee7\u7eed:%s", tb.getTableName(), data.size(), skipOffset, totalCount, isContinue));
                            throw throwable;
                        }
                    }
                    System.err.println(String.format("\u6b63\u5728\u6267\u884c\u8868=%s;\u6570\u636e=%s, skipOffset=%s,totalCount=%s;\u662f\u5426\u7ee7\u7eed:%s", tb.getTableName(), data.size(), skipOffset, totalCount, isContinue));
                } while (isContinue);
                successAtomicCount.incrementAndGet();
                subStopWatch.stop();
                processedMessage.append(String.format("[cost:%s s]-Done for table=%s(\u6570\u91cf=%s);", subStopWatch.getTotalTimeSeconds(), tb.getTableName(), totalCount));
                int prt = processedAtomicIndex.incrementAndGet();
                System.err.println(String.format("\u5b8c\u6210\u62c9\u53d6:Done for:%s -%s", tb.getTableName(), prt));
                processedMessage.append((CharSequence)sqlBuilderTracking);
                if (processedAtomicIndex.get() % 5 == 0) {
                    executeIndex.incrementAndGet();
                }
                try {
                    Object[] params = new Object[]{1, processedMessage.toString(), requestId};
                    this.jdbcTemplate.update("UPDATE sync_change_logs SET current=current+?,result=?,last_updated_time=CURRENT_TIMESTAMP WHERE ID=?", params);
                }
                catch (Exception ex) {
                    logger.error("Update \u8868\u5185\u5bb9(sql={})\u53d1\u751f\u5f02\u5e38:{}", new Object[]{"UPDATE sync_change_logs SET current=current+?,result=?,last_updated_time=CURRENT_TIMESTAMP WHERE ID=?", processedMessage, ex});
                }
                break block24;
                catch (Exception ex) {
                    try {
                        if (subStopWatch.isRunning()) {
                            subStopWatch.stop();
                        }
                        String detail = ExceptionUtils.getStackMessage((Throwable)ex);
                        processedMessage.append(String.format("[cost:%s s]-(skipOffset=%s)-Error for table=%s(\u6570\u91cf=%s;\u6d88\u606f=%s);", subStopWatch.getTotalTimeSeconds(), skipOffset, tb.getTableName(), totalCount, ex.getMessage()));
                        if (!detail.contains("\u6a21\u677f")) {
                            errorMessage.append(String.format("[cost:%s s]-(skipOffset=%s)Error for table=%s(\u6570\u91cf=%s;\u6d88\u606f=%s);", subStopWatch.getTotalTimeSeconds(), skipOffset, tb.getTableName(), totalCount, detail));
                            detailContainer.put(tb.getTableName(), String.format("\u5f02\u5e38:%s", detail));
                            changeLogBadExceptions.add(ex);
                        }
                        logger.error("Error for table={},totalCount={};", new Object[]{tb.getTableName(), totalCount, ex});
                        System.err.println(String.format("Error for table=%s,totalCount=%s;\u5f02\u5e38\u4fe1\u606f=%s;", tb.getTableName(), totalCount, detail));
                        prt = processedAtomicIndex.incrementAndGet();
                    }
                    catch (Throwable throwable) {
                        int prt2 = processedAtomicIndex.incrementAndGet();
                        System.err.println(String.format("\u5b8c\u6210\u62c9\u53d6:Done for:%s -%s", tb.getTableName(), prt2));
                        processedMessage.append((CharSequence)sqlBuilderTracking);
                        if (processedAtomicIndex.get() % 5 == 0) {
                            executeIndex.incrementAndGet();
                        }
                        try {
                            Object[] params = new Object[]{1, processedMessage.toString(), requestId};
                            this.jdbcTemplate.update("UPDATE sync_change_logs SET current=current+?,result=?,last_updated_time=CURRENT_TIMESTAMP WHERE ID=?", params);
                        }
                        catch (Exception ex2) {
                            logger.error("Update \u8868\u5185\u5bb9(sql={})\u53d1\u751f\u5f02\u5e38:{}", new Object[]{"UPDATE sync_change_logs SET current=current+?,result=?,last_updated_time=CURRENT_TIMESTAMP WHERE ID=?", processedMessage, ex2});
                        }
                        throw throwable;
                    }
                    System.err.println(String.format("\u5b8c\u6210\u62c9\u53d6:Done for:%s -%s", tb.getTableName(), prt));
                    processedMessage.append((CharSequence)sqlBuilderTracking);
                    if (processedAtomicIndex.get() % 5 == 0) {
                        executeIndex.incrementAndGet();
                    }
                    try {
                        Object[] params = new Object[]{1, processedMessage.toString(), requestId};
                        this.jdbcTemplate.update("UPDATE sync_change_logs SET current=current+?,result=?,last_updated_time=CURRENT_TIMESTAMP WHERE ID=?", params);
                    }
                    catch (Exception ex3) {
                        logger.error("Update \u8868\u5185\u5bb9(sql={})\u53d1\u751f\u5f02\u5e38:{}", new Object[]{"UPDATE sync_change_logs SET current=current+?,result=?,last_updated_time=CURRENT_TIMESTAMP WHERE ID=?", processedMessage, ex3});
                    }
                }
            }
        });
        watch.stop();
        int doubleCheckIndex = 0;
        while (processedAtomicIndex.get() < tables.size()) {
            System.err.println(String.format("\u5f53\u524d\u83b7\u53d6\u5f97\u6570\u636e:%s", processedAtomicIndex.get()));
            ThreadUtil.sleep((long)10000L);
            if (++doubleCheckIndex <= 10) continue;
        }
        logger.error("waiting for all done");
        System.err.println("Waiting for all done...");
        try {
            Object[] params = new Object[3];
            params[0] = processedAtomicIndex.get();
            Object[] objectArray = new Object[4];
            objectArray[0] = processedTotalCount;
            objectArray[1] = processedAtomicIndex.get() == tables.size() ? (errorMessage.length() == 0 ? "\u6210\u529f" : "\u5b8c\u6210\u4f46\u9519\u8bef") : "\u5f02\u5e38";
            objectArray[2] = errorMessage;
            objectArray[3] = processedMessage;
            String content = String.format("[\u5b8c\u6210:\u62c9\u53d6\u6570\u91cf=%s(\u72b6\u6001=%s)-%s]:%s;", objectArray);
            if (content.length() > 55000) {
                content = String.format("%s ....", content.substring(0, 55000));
            }
            params[1] = content;
            params[2] = requestId;
            this.jdbcTemplate.update("UPDATE sync_change_logs SET current=?,result=?,last_updated_time=CURRENT_TIMESTAMP WHERE ID=?", params);
        }
        catch (Exception ex) {
            logger.error("Update SQL({}) \u53d1\u751f\u5f02\u5e38:{}", new Object[]{"UPDATE sync_change_logs SET current=current+?,result=?,last_updated_time=CURRENT_TIMESTAMP WHERE ID=?", String.format("[\u5b8c\u6210:\u603b\u6267\u884c\u6b21\u6570=%s]:%s", processedTotalCount, processedMessage), ex});
        }
        if (successAtomicCount.get() == 0 || storedPaths.size() == 0) {
            logger.error("not success atomic count data");
            throw new SaasNofoundException(String.format("\u627e\u4e0d\u5230\u4efb\u4f55\u6761\u4ef6(FromTime=%s;RegionCode=%s)\u7684\u6570\u636e", request.getFromTime(), request.getRegionCode()));
        }
    }

    private void responseWithFile(String title, String realPath, HttpServletResponse response) throws IOException {
        File dir = new File(realPath);
        File[] files = dir.listFiles();
        if (files == null) {
            response.setStatus(HttpStatus.NOT_FOUND.value());
            response.getWriter().write(String.format("\u627e\u4e0d\u5230\u8981\u4e0b\u8f7d\u7684\u6587\u4ef6(%s)", title));
            return;
        }
        Optional<File> fileOptional = Arrays.stream(files).filter(ii -> ii.getName().endsWith(".zip")).findFirst();
        if (!fileOptional.isPresent()) {
            response.setStatus(HttpStatus.NOT_FOUND.value());
            response.getWriter().write(String.format("%s \u5e95\u4e0b\u627e\u4e0d\u7b26\u5408\u7684\u6253\u5305\u6587\u4ef6, \u8bf7\u91cd\u65b0\u751f\u6210", title));
            return;
        }
        File selectedFile = fileOptional.get();
        String encoding = Environment.getInstance().getEncoding();
        response.setContentType("application/x-download; charset=" + encoding + "");
        response.setHeader("Content-Disposition", "attachment;filename=\"" + URLEncoder.encode(selectedFile.getName(), encoding) + "\"");
        try (ServletOutputStream outputStream = response.getOutputStream();){
            try (BufferedInputStream reader = new BufferedInputStream(new FileInputStream(selectedFile));){
                byte[] buffer = new byte[4096];
                int i = -1;
                while ((i = reader.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, i);
                }
            }
            outputStream.flush();
        }
    }

    private Collection<ChangeLogTableMapDto> getAllChangeLogTemplates() {
        _changeLogTableMaps = new ArrayList<ChangeLogTableMapDto>();
        if (CollectionUtils.isEmpty(_changeLogTableMaps)) {
            _changeLogTableMaps = this.jdbcTemplate.query("SELECT template,mapkey,region FROM dynamic_data_map_templates", (rs, rowNum) -> {
                String template = rs.getString("template");
                String mapKey = rs.getString("mapkey");
                String region = rs.getString("region");
                return ChangeLogTableMapDto.create(mapKey, template, region);
            });
        }
        if (_changeLogTableMaps == null) {
            _changeLogTableMaps = new ArrayList<ChangeLogTableMapDto>();
        }
        return _changeLogTableMaps;
    }

    private Collection<SyncChangeLogTableDto> getChangelogTables(DownChangelogRequest request) {
        _syncChangeLogTables = new ArrayList<SyncChangeLogTableDto>();
        if (CollectionUtils.isEmpty(_syncChangeLogTables)) {
            _syncChangeLogTables = this.jdbcTemplate.query("select app.app_id,f.name,sf.filter, f.table_name,sf.is_online,sf.config,st.config as target_config,st.url\nfrom meta_apps app join meta_forms f on app.id=f.application_meta_id\njoin sync_meta_forms sf on f.id=sf.form_meta_id\njoin sync_meta_form_targets st on st.id=sf.target_meta_id\nwhere sf.is_online=1 and st.url like '%v2/ftp%' ", (rs, rowNum) -> {
                String name = rs.getString("name");
                String tableName = rs.getString("table_name");
                String appId = rs.getString("app_id");
                String config = rs.getString("config");
                String target_config = rs.getString("target_config");
                String url = rs.getString("url");
                String filter = rs.getString("filter");
                boolean is_online = rs.getBoolean("is_online");
                return SyncChangeLogTableDto.create(name, tableName, filter, appId, config, target_config, url, is_online);
            });
            Collection<ChangeLogTableMapDto> templates = this.getAllChangeLogTemplates();
            if (!CollectionUtils.isEmpty(_syncChangeLogTables = (Collection)_syncChangeLogTables.stream().filter(ii -> templates.stream().anyMatch(ix -> ix.getMapKey().equalsIgnoreCase(ii.getMapKey()))).collect(Collectors.toList()))) {
                for (SyncChangeLogTableDto syncChangeLogTableDto : _syncChangeLogTables) {
                    Collection selectedTemplates = templates.stream().filter(ii -> ii.getMapKey().equalsIgnoreCase(syncChangeLogTableDto.getMapKey()) && (!StringUtils.hasLength((String)ii.getRegion()) || !StringUtils.hasLength((String)request.getRegionCode()) || ii.getRegion().contains(request.getRegionCode()))).collect(Collectors.toList());
                    syncChangeLogTableDto.assignTemplates(selectedTemplates);
                }
            }
        }
        return _syncChangeLogTables;
    }

    private ChangeLogDataResult getChangelogData(SyncChangeLogTableDto table, int skipOffset, DownChangelogRequest request) {
        String appId = table.getAppId();
        ChangeLogDataResult data = this.getData(table, skipOffset, this.getSelectedDataSource(appId), request);
        return data;
    }

    private DataSource getSelectedDataSource(String appId) {
        if (this.isObpmDataSource(appId)) {
            return null;
        }
        DataSource dataSource = _selectedDataSourceByAppId.get(appId);
        if (dataSource == null) {
            Application application = (Application)DesignTimeSerializableCache.get((String)appId);
            if (application == null) {
                return null;
            }
            dataSource = application.getDataSourceDefine();
            if (dataSource == null) {
                return null;
            }
            _selectedDataSourceByAppId.put(appId, dataSource);
        }
        return dataSource;
    }

    private ChangeLogDataResult getData(SyncChangeLogTableDto table, int skipOffset, DataSource dataSource, DownChangelogRequest request) {
        String currentSql = null;
        String dsIdentity = null;
        try {
            JdbcTemplate selectedJdbcTemplate = this.jdbcTemplate;
            if (!this.isObpmDataSource(table.getAppId())) {
                if (dataSource == null) {
                    throw new SaasBadException(String.format("\u627e\u4e0d\u5230(%s)\u7684dataSource\u6570\u636e\u6e90", table.getTableName()));
                }
                dsIdentity = dataSource.getIdentityUri();
                selectedJdbcTemplate = _selectedJdbcTemplateByDsId.get(dataSource.getIdentityUri());
                if (selectedJdbcTemplate == null) {
                    javax.sql.DataSource ds = PersistenceUtils.getDataSource((DataSource)dataSource);
                    if (ds == null) {
                        throw new SaasBadException(String.format("(%s)\u7684\u6570\u636e\u6e90\u65e0\u6548", table.getTableName()));
                    }
                    selectedJdbcTemplate = new JdbcTemplate(ds);
                    _selectedJdbcTemplateByDsId.put(dataSource.getIdentityUri(), selectedJdbcTemplate);
                }
            }
            String regionId = this.regionConfig.getRegionId(request.getRegionCode());
            String sql = table.getSql(regionId, request.getFromTime(), request.getEndTime());
            ArrayList<Map<String, Object>> mergedResults = new ArrayList<Map<String, Object>>();
            int offset = skipOffset;
            int take = 2500;
            Collection<Map<String, Object>> currentPageData = null;
            int index = 0;
            StringBuilder sb = new StringBuilder();
            do {
                try {
                    currentSql = String.format("%s limit %s,%s", sql, offset, take);
                    currentPageData = this.executeQueryWithoutLock(selectedJdbcTemplate, currentSql);
                    if (index < 1) {
                        sb.append(String.format("size=%s;sql=%s;", currentPageData.size(), currentSql));
                    }
                    mergedResults.addAll(currentPageData);
                    System.err.println(String.format("offset=%s:\u62c9\u53d6\u5230\u7684\u6570\u636e=%s;\u5927\u5c0f=%s;", offset += take, currentSql, mergedResults.size()));
                    if (this.isReachMaxCount(mergedResults)) break;
                    ++index;
                }
                catch (Exception ex) {
                    if (ex.toString().contains("time") && take > 500) {
                        take -= 100;
                    }
                    ++index;
                    sb.append(String.format("exception=%s;size=%s;sql=%s;", ex, currentPageData == null ? "NULL" : Integer.valueOf(currentPageData.size()), currentSql));
                    logger.error("\u811a\u672c\u6267\u884c\u5f02\u5e38:{}", (Object)sb, (Object)ex);
                    System.err.println(String.format("\u62c9\u53d6\u811a\u672c\u53d1\u751f\u5f02\u5e38:SQL=%s;\u5f02\u5e38=%s;", currentSql, ex.toString()));
                }
            } while (!CollectionUtils.isEmpty(currentPageData) && currentPageData.size() >= take && index < 5);
            ChangeLogDataResult dataResult = ChangeLogDataResult.create(mergedResults);
            dataResult.appendTracking(String.format("[\u603b\u5171\u6267\u884c\u6b21\u6570=%s]\u8ddf\u8e2a\u8bb0\u5f55:%s;", index, sb));
            return dataResult;
        }
        catch (Exception ex) {
            throw new ChangeLogBadException(table.getTableName(), String.format("\u6570\u636e\u83b7\u53d6\u5f02\u5e38:%s\u3010\u6570\u636e\u6e90=%s\u3011;sql=%s;", ex.getMessage(), dsIdentity, currentSql), ex);
        }
    }

    private Collection<TranslateSqlResult> translate2Sql(ChangeLogContext changeLogContext, Collection<Map<String, Object>> data) {
        if (CollectionUtils.isEmpty(data)) {
            return Collections.emptyList();
        }
        List sqlResult = Collections.synchronizedList(new ArrayList());
        data.stream().forEach(dt -> {
            HashSet<String> paths = new HashSet<String>();
            Map<String, Object> mapValues = changeLogContext.getParams((Map<String, Object>)dt);
            String translatedSql = changeLogContext.getSqlTemplates().stream().map(tmp -> {
                try {
                    String mapResult = tmp;
                    for (Object key : mapValues.keySet()) {
                        if (key == null) continue;
                        Object originalValue = null;
                        try {
                            Collection extractPaths;
                            originalValue = mapValues.get(key);
                            if (originalValue != null && FieldNames.isFile((String)String.valueOf(key)) && !CollectionUtils.isEmpty((Collection)(extractPaths = FieldNames.extractPathValues((String)this.regionConfig.getSourceSite(), (String)String.valueOf(originalValue))))) {
                                for (String singlePath : extractPaths) {
                                    if (!StringUtils.hasLength((String)singlePath)) continue;
                                    if (StringUtils.hasLength((String)this.regionConfig.getSourceSite()) && this.regionConfig.getSourceSite().contains("cn-north-1.myhuaweicloud.com")) {
                                        singlePath = singlePath.replace(String.format("%s/obpm", this.regionConfig.getSourceSite()), this.regionConfig.getSourceSite());
                                    }
                                    if (singlePath.contains("02obs-file-system-obpm-uploads.obs.cn-north-1.myhuaweicloud.com") && singlePath.contains("/obpm/uploads/")) {
                                        singlePath = singlePath.replace("/obpm/uploads/", "/");
                                    }
                                    paths.add(singlePath);
                                }
                            }
                            mapResult = this.mappingSqlValueTranslator.get(changeLogContext, mapResult, String.valueOf(key), originalValue);
                        }
                        catch (Exception ex) {
                            throw new SaasBadException(String.format("\u5b57\u6bb5\u4fe1\u606f\u5f02\u5e38:key=%s;value=%s;\u8be6\u60c5=%s", key, originalValue, ExceptionUtils.getStackMessage((Throwable)ex)));
                        }
                    }
                    if (StringUtils.hasLength((String)mapResult) && (mapResult = mapResult.trim()).endsWith(";")) {
                        mapResult = mapResult.substring(0, mapResult.length() - 1);
                    }
                    return mapResult;
                }
                catch (Exception ex) {
                    logger.error("[{}];ex_Sql={};\u8be6\u7ec6;", new Object[]{mapValues.containsKey("id") ? "" : mapValues.get("id"), tmp, ex});
                    return String.format("[%s];ex_Sql=%s;\u8be6\u7ec6=%s;", mapValues.containsKey("id") ? "" : mapValues.get("id"), tmp, ExceptionUtils.getStackMessage((Throwable)ex));
                }
            }).filter(ii -> StringUtils.hasLength((String)ii)).collect(Collectors.joining(";"));
            sqlResult.add(TranslateSqlResult.create(translatedSql, paths));
        });
        Collection rt = sqlResult.stream().filter(ii -> ii != null).collect(Collectors.toList());
        if (rt.size() != data.size()) {
            System.err.println(String.format("\u544a\u8b66:\u6570\u636e\u4e0d\u4e00\u81f4;%s!=%s", rt.size(), data.size()));
        }
        return rt;
    }

    private Collection<String> store(SyncChangeLogTableDto table, String rootPath, int skipOffset, Collection<TranslateSqlResult> sqlResults) {
        if (CollectionUtils.isEmpty(sqlResults)) {
            return Collections.emptyList();
        }
        StringBuilder builder = new StringBuilder();
        for (TranslateSqlResult sqlResult : sqlResults) {
            if (sqlResult == null) continue;
            try {
                String sql = sqlResult.getSql();
                if (!StringUtils.hasLength((String)sql)) continue;
                if ((sql = sql.trim()).endsWith(";")) {
                    sql = sql.substring(0, sql.length() - 1);
                }
                builder.append(String.format("%s;", sql));
            }
            catch (Exception ex) {
                System.err.println(String.format("\u811a\u672c\u89e3\u6790\u53d1\u751f\u5f02\u5e38:%s;message=%s", sqlResult, ExceptionUtils.getStackMessage((Throwable)ex)));
            }
        }
        String storePath = rootPath.concat(File.separator).concat(table.getAppId());
        ArrayList<String> pathResult = new ArrayList<String>();
        String sql_path = String.format("%s%s_%s_%s.sql", storePath, table.getTableName(), table.getAppId(), skipOffset);
        FileUtil.appendString((String)builder.toString(), (String)sql_path, (Charset)StandardCharsets.UTF_8);
        pathResult.add(sql_path);
        Collection filePaths = sqlResults.stream().flatMap(ii -> ii.getPaths().stream()).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty((Collection)filePaths)) {
            String file_path = sql_path.replace(".sql", "_file.txt");
            FileUtil.appendLines((Collection)filePaths, (String)file_path, (String)"utf-8");
            pathResult.add(file_path);
        }
        return pathResult;
    }

    private boolean isObpmDataSource(String appId) {
        return appId.contains("tenant");
    }

    private String getDbName(String url) {
        if (!StringUtils.hasLength((String)url)) {
            return null;
        }
        if (!url.contains("?")) {
            return url;
        }
        String prefix = url.substring(0, url.indexOf("?"));
        return prefix.substring(url.lastIndexOf("/"));
    }

    private boolean isReachMaxCount(Collection<Map<String, Object>> data) {
        if (CollectionUtils.isEmpty(data)) {
            return false;
        }
        return data.size() >= 15000;
    }

    private boolean isChangeLogsFinished(String zipId) {
        Object[] param = new Object[]{zipId};
        Map queryResult = this.jdbcTemplate.queryForMap("select id,name,path,createdTime,total,current,result,last_updated_time from sync_change_logs where id=?", param);
        long current = ((Integer)queryResult.get("current")).longValue();
        long total = ((Integer)queryResult.get("total")).longValue();
        LocalDateTime lastUpdatedTime = (LocalDateTime)queryResult.get("last_updated_time");
        return current == total && Duration.between(lastUpdatedTime, LocalDateTime.now()).getSeconds() > 180L;
    }

    private CompletableFuture<ResponseEntity<DownloadChangelogResponse>> validateEndTime(DownChangelogRequest request) {
        Date now = new Date();
        if (request.getEndTime() != null && request.getEndTime().after(now)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            ConcurrentHashMap<String, String> requestMap = new ConcurrentHashMap<String, String>();
            DateTime endDateTime = request.getEndTime();
            DateTime nowDateTime = new DateTime(now);
            request.setEndTime(nowDateTime);
            requestMap.put("request", this.jsonProvider.getJson((Object)request));
            DownloadChangelogResponse resp = DownloadChangelogResponse.create("\u5f02\u5e38", "\u5f02\u5e38", requestMap, null, "\u8bf7\u6c42\u7684 endTime: " + dateFormat.format((Date)endDateTime) + " \u65e9\u4e8e\u670d\u52a1\u5668\u5f53\u524d\u65f6\u95f4\uff0c\u8bf7\u68c0\u67e5\u65f6\u95f4\u8bbe\u7f6e\u3002\u670d\u52a1\u5668\u65f6\u95f4\uff1a" + dateFormat.format(now));
            return CompletableFuture.completedFuture(ResponseEntity.ok().body((Object)resp));
        }
        return null;
    }

    @Transactional(isolation=Isolation.READ_UNCOMMITTED, readOnly=true)
    public Collection<Map<String, Object>> executeQueryWithoutLock(JdbcTemplate selectedJdbcTemplate, String currentSql) {
        ArrayList currentPageData = (ArrayList)selectedJdbcTemplate.query(currentSql, rse -> {
            ArrayList dsx = new ArrayList();
            ResultSetMetaData metaData = rse.getMetaData();
            int columnCount = metaData.getColumnCount();
            while (rse.next()) {
                HashMap<String, Object> mp = new HashMap<String, Object>();
                for (int ci = 0; ci < columnCount; ++ci) {
                    Object value;
                    String column;
                    block7: {
                        column = null;
                        int ciIndex = ci + 1;
                        int columnType = metaData.getColumnType(ciIndex);
                        try {
                            column = metaData.getColumnLabel(ciIndex);
                        }
                        catch (Exception ex) {
                            column = metaData.getColumnName(ciIndex);
                        }
                        value = null;
                        try {
                            value = rse.getObject(column);
                            if (value instanceof Boolean && "bit".equalsIgnoreCase(metaData.getColumnTypeName(ciIndex))) {
                                value = (Boolean)value != false ? "1" : "0";
                            }
                        }
                        catch (Exception ex) {
                            value = String.format("%s:exception=%s", rse.getString(column), ex.toString());
                            logger.error("\u88ab\u5ffd\u7565\u4e3aNULL; column={};value={};", new Object[]{column, value, ex});
                            if (!ex.toString().contains("0000-00-00")) break block7;
                            value = null;
                        }
                    }
                    mp.put(column, value);
                }
                dsx.add(mp);
            }
            return dsx;
        });
        if (currentPageData == null) {
            currentPageData = new ArrayList();
        }
        return currentPageData;
    }

    static {
        _selectedDataSourceByAppId = new ConcurrentHashMap<String, DataSource>();
        _selectedJdbcTemplateByDsId = new ConcurrentHashMap<String, JdbcTemplate>();
    }
}

