/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.apis.configs;

import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Configuration
@ConfigurationProperties(prefix="myapps.region")
public class RegionConfig {
    private String sourceSite;
    private boolean disabled;
    private Map<String, RegionConfigItem> mappings;

    public String getDomainId(String regionCode) {
        if (CollectionUtils.isEmpty(this.getMappings()) || !StringUtils.hasLength((String)regionCode)) {
            return null;
        }
        RegionConfigItem configItem = this.getMappings().get(regionCode);
        if (configItem == null) {
            return null;
        }
        return configItem.getDomainId();
    }

    public String getRegionId(String regionCode) {
        RegionConfigItem configItem = this.getSelectedRegionConfigItem(regionCode);
        if (configItem == null) {
            return null;
        }
        return configItem.getPrefixId();
    }

    public RegionConfigItem getSelectedRegionConfigItem(String regionCode) {
        if (CollectionUtils.isEmpty(this.getMappings()) || !StringUtils.hasLength((String)regionCode)) {
            return null;
        }
        if (this.getMappings().size() == 1 && this.getMappings().get("public") != null) {
            return this.getMappings().get("public");
        }
        RegionConfigItem configItem = this.getMappings().get(regionCode);
        if (configItem == null) {
            return null;
        }
        return configItem;
    }

    public String getSourceSite() {
        return this.sourceSite;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public Map<String, RegionConfigItem> getMappings() {
        return this.mappings;
    }

    public void setSourceSite(String sourceSite) {
        this.sourceSite = sourceSite;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setMappings(Map<String, RegionConfigItem> mappings) {
        this.mappings = mappings;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegionConfig)) {
            return false;
        }
        RegionConfig other = (RegionConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDisabled() != other.isDisabled()) {
            return false;
        }
        String this$sourceSite = this.getSourceSite();
        String other$sourceSite = other.getSourceSite();
        if (this$sourceSite == null ? other$sourceSite != null : !this$sourceSite.equals(other$sourceSite)) {
            return false;
        }
        Map<String, RegionConfigItem> this$mappings = this.getMappings();
        Map<String, RegionConfigItem> other$mappings = other.getMappings();
        return !(this$mappings == null ? other$mappings != null : !((Object)this$mappings).equals(other$mappings));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RegionConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDisabled() ? 79 : 97);
        String $sourceSite = this.getSourceSite();
        result = result * 59 + ($sourceSite == null ? 43 : $sourceSite.hashCode());
        Map<String, RegionConfigItem> $mappings = this.getMappings();
        result = result * 59 + ($mappings == null ? 43 : ((Object)$mappings).hashCode());
        return result;
    }

    public String toString() {
        return "RegionConfig(sourceSite=" + this.getSourceSite() + ", disabled=" + this.isDisabled() + ", mappings=" + this.getMappings() + ")";
    }

    public static class RegionConfigItem {
        private String prefixId;
        private String domainId;
        private Map<String, String> dbMaps;

        public String getRealDbName(String bDbName) {
            if (CollectionUtils.isEmpty(this.getDbMaps())) {
                return null;
            }
            return this.getDbMaps().get(bDbName);
        }

        public String getPrefixId() {
            return this.prefixId;
        }

        public String getDomainId() {
            return this.domainId;
        }

        public Map<String, String> getDbMaps() {
            return this.dbMaps;
        }

        public void setPrefixId(String prefixId) {
            this.prefixId = prefixId;
        }

        public void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        public void setDbMaps(Map<String, String> dbMaps) {
            this.dbMaps = dbMaps;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RegionConfigItem)) {
                return false;
            }
            RegionConfigItem other = (RegionConfigItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$prefixId = this.getPrefixId();
            String other$prefixId = other.getPrefixId();
            if (this$prefixId == null ? other$prefixId != null : !this$prefixId.equals(other$prefixId)) {
                return false;
            }
            String this$domainId = this.getDomainId();
            String other$domainId = other.getDomainId();
            if (this$domainId == null ? other$domainId != null : !this$domainId.equals(other$domainId)) {
                return false;
            }
            Map<String, String> this$dbMaps = this.getDbMaps();
            Map<String, String> other$dbMaps = other.getDbMaps();
            return !(this$dbMaps == null ? other$dbMaps != null : !((Object)this$dbMaps).equals(other$dbMaps));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RegionConfigItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $prefixId = this.getPrefixId();
            result = result * 59 + ($prefixId == null ? 43 : $prefixId.hashCode());
            String $domainId = this.getDomainId();
            result = result * 59 + ($domainId == null ? 43 : $domainId.hashCode());
            Map<String, String> $dbMaps = this.getDbMaps();
            result = result * 59 + ($dbMaps == null ? 43 : ((Object)$dbMaps).hashCode());
            return result;
        }

        public String toString() {
            return "RegionConfig.RegionConfigItem(prefixId=" + this.getPrefixId() + ", domainId=" + this.getDomainId() + ", dbMaps=" + this.getDbMaps() + ")";
        }
    }
}

