package com.bcxin.shared.rest.web.apis.controllers.rbacs;

import com.bcxin.api.interfaces.rbacs.RbacResourceRpcProvider;
import com.bcxin.api.interfaces.rbacs.requests.ResourceRequest;
import com.bcxin.api.interfaces.rbacs.responses.ResourceGetResponse;
import com.bcxin.rest.web.commons.ControllerAbstract;
import jdk.nashorn.internal.objects.annotations.Getter;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Collection;

@RestController
@RequestMapping("/rbac/categories/{categoryId}/resources")
public class ResourceController extends ControllerAbstract {
    private final RbacResourceRpcProvider resourceRpcProvider;

    public ResourceController(RbacResourceRpcProvider resourceRpcProvider) {
        this.resourceRpcProvider = resourceRpcProvider;
    }

    @PostMapping
    public ResponseEntity post(@PathVariable String categoryId, @RequestBody ResourceRequest request) {
        this.resourceRpcProvider.create(categoryId, request);

        return this.ok();
    }

    @PutMapping("/{id}")
    public ResponseEntity put(@PathVariable String categoryId, @PathVariable String id, @RequestBody ResourceRequest request) {
        this.resourceRpcProvider.update(categoryId, id, request);

        return this.ok();
    }

    @DeleteMapping("/{id}")
    public ResponseEntity delete(@PathVariable String categoryId, @PathVariable String id) {
        this.resourceRpcProvider.delete(categoryId, id);

        return this.ok();
    }

    @GetMapping
    public ResponseEntity get(@PathVariable String categoryId) {
        Collection<ResourceGetResponse> responses = this.resourceRpcProvider.getAll(categoryId);

        return this.ok(responses);
    }
}
