package com.bcxin.shared.rest.web.apis.controllers.commons;

import com.bcxin.api.interfaces.commons.ConfigDictRpcProvider;
import com.bcxin.rest.web.commons.ControllerAbstract;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/common/dict")
public class ConfigDictController extends ControllerAbstract {

    private final ConfigDictRpcProvider configDictRpcProvider;

    public ConfigDictController(ConfigDictRpcProvider configDictRpcProvider) {
        this.configDictRpcProvider = configDictRpcProvider;
    }


    @GetMapping("/all")
    public ResponseEntity all() {
        return this.ok(this.configDictRpcProvider.findAll());
    }


    /**
     * description: 获取注册页面数据字典列表
     * author: linchunpeng
     * date:  2023-05-08 14:47
     */
    @GetMapping("/register")
    public ResponseEntity findRegisterDict() {
        return this.ok(this.configDictRpcProvider.findRegisterDict());
    }

    /**
     * description: 根据行业类型，获取机构类型列表
     * author: linchunpeng
     * date:  2023-05-08 13:10
     */
    @GetMapping("/org/type/{industryTypeValue}")
    public ResponseEntity getOrgTypeList(@PathVariable("industryTypeValue") String industryTypeValue) {
        return this.ok(this.configDictRpcProvider.getOrgTypeList(industryTypeValue));
    }

//    /**
//     * description：根据机构类型，获取主管单位列表
//     * author：linchunpeng
//     * date：2023/9/12
//     */
//    @GetMapping("/org/competent/unit/code/{institutionalCode}")
//    public ResponseEntity getCompetentUnitCodeList(@PathVariable("institutionalCode") String institutionalCode) {
//        return this.ok(this.configDictRpcProvider.getCompetentUnitCodeList(institutionalCode));
//    }

    /**
     * description: 删除注册页面数据字典缓存
     * author: linchunpeng
     * date:  2023-05-08 14:34
     */
    @GetMapping("/register/clear/redis")
    public ResponseEntity clearRegisterDictRedis() {
        this.configDictRpcProvider.clearRegisterDictRedis();
        return this.ok();
    }
}
