package com.bcxin.tenant.apis.translates.impls;

import com.bcxin.api.interfaces.tenants.requests.organizationRelationship.OrganizationRelationshipInfoUpdateRequest;
import com.bcxin.api.interfaces.tenants.responses.OrganizationStructureResponse;
import com.bcxin.tenant.apis.translates.OrganizationRelationshipTranslate;
import com.bcxin.tenant.domain.repositories.dtos.OrganizationRelationshipInfoDto;
import com.bcxin.tenant.domain.services.commands.organizationrelationship.OrganizationRelationshipInfoUpdateCommand;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

@Component
public class OrganizationRelationshipTranslateImpl implements OrganizationRelationshipTranslate {
    @Override
    public OrganizationRelationshipInfoUpdateCommand translate2InfoUpdateCommand(OrganizationRelationshipInfoUpdateRequest request) {
        return OrganizationRelationshipInfoUpdateCommand.create(request.getId(),
                request.getOrganizationNote(),
                request.getOrganizationTypeId(),
                request.getParentId(),
                request.getParentName(),
                request.getParentIndex(),
                request.getCode(),
                request.getContactName(),
                request.getContactTelephone(),
                request.getOrganizationId());
    }

    @Override
    public OrganizationStructureResponse translate2OrganizationStructureResponse(OrganizationRelationshipInfoDto infoDto) {
        OrganizationStructureResponse.OrganizationTypeResponse organizationType =
                infoDto.getOrganizationType() == null ? null :
                        OrganizationStructureResponse.OrganizationTypeResponse.create(
                                infoDto.getOrganizationType().getId(),
                                infoDto.getOrganizationType().getName(),
                                infoDto.getOrganizationType().getNote());

        OrganizationStructureResponse.OrganizationStatisticsResponse staticsResponse =
                infoDto.getOrganizationStatistics() == null ? null :
                        OrganizationStructureResponse.OrganizationStatisticsResponse.create(
                                infoDto.getOrganizationStatistics().getOrgId(),
                                infoDto.getOrganizationStatistics().getUnifySocialCreditCode(),
                                infoDto.getOrganizationStatistics().getCountOfMembers());

        OrganizationStructureResponse response = OrganizationStructureResponse.create(infoDto.getId(),
                infoDto.getSelectedOrganizationId(),
                infoDto.getSelectedOrganizationName(),
                infoDto.getSelectedOrganizationNote(),
                infoDto.getCode(),
                infoDto.getContactName(),
                infoDto.getContactTelephone(),
                organizationType,
                infoDto.getStatus(),
                infoDto.getOrganizationId(),
                infoDto.getInviteType(),
                staticsResponse,
                new ArrayList<>());
        return response;
    }
}
