package com.bcxin.tenant.apis.impls;

import com.bcxin.Infrastructures.components.JsonProvider;
import com.bcxin.Infrastructures.enums.ProcessedStatus;
import com.bcxin.Infrastructures.exceptions.NotFoundTenantException;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.commons.DownloadImportedResponse;
import com.bcxin.api.interfaces.commons.ImportedResponseItem;
import com.bcxin.api.interfaces.tenants.ResourceRpcProvider;
import com.bcxin.tenant.apis.translates.CommonTranslate;
import com.bcxin.tenant.domain.entities.ImportDataEntity;
import com.bcxin.tenant.domain.repositories.ImportDataEntityRepository;
import org.apache.dubbo.config.annotation.DubboService;
import java.util.Collection;
import java.util.Optional;

@DubboService(version = ApiConstant.VERSION,validation = "true",retries = 0,timeout = 120_000 )
public class ResourceRpcProviderImpl implements ResourceRpcProvider {
    private final ImportDataEntityRepository importDataEntityRepository;
    private final JsonProvider jsonProvider;
    private final CommonTranslate commonTranslate;

    public ResourceRpcProviderImpl(ImportDataEntityRepository importDataEntityRepository,
                                   JsonProvider jsonProvider, CommonTranslate commonTranslate) {
        this.importDataEntityRepository = importDataEntityRepository;
        this.jsonProvider = jsonProvider;
        this.commonTranslate = commonTranslate;
    }

    @Override
    public DownloadImportedResponse getImportResult(String resourceId, String category) {
        Optional<ImportDataEntity> entityOptional = this.importDataEntityRepository.findById(resourceId);
        if (!entityOptional.isPresent()) {
            throw new NotFoundTenantException();
        }
        ImportDataEntity entity = entityOptional.get();

        Collection<ImportedResponseItem> report = null;
        int totalSuccess = (int) entity.getDataItems().stream().filter(ii -> ii.getStatus() == ProcessedStatus.Done).count();
                int totalFailed = (int) entity.getDataItems().stream().filter(ii -> ii.getStatus() == ProcessedStatus.Error).count();

                switch (category) {
                    case "department":
                        report = this.commonTranslate.Translate2ImportDepartmentResponse(entity.getDataItems());
                        break;
                    case "employee":
                        report = this.commonTranslate.Translate2ImportEmployeeResponse(entity.getDataItems());
                        break;
                    case "contract":
                        report = this.commonTranslate.Translate2ImportContractResponse(entity.getDataItems());
                        break;
                    case "employee_leave":
                        report = this.commonTranslate.Translate2LeaveEmployeeResponse(entity.getDataItems());
                break;
        }

        return DownloadImportedResponse.create(entity.getPath(), entity.getOrganizationId(), totalSuccess, totalFailed, report);
    }
}
