package com.bcxin.tenant.apis.impls;

import com.bcxin.Infrastructures.Pageable;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.tenants.OrganizationAdminRpcProvider;
import com.bcxin.api.interfaces.tenants.criterias.OrganizationAdminCriteria;
import com.bcxin.api.interfaces.tenants.requests.orgainzaitionAdmins.CreateOrganizationAdminRequest;
import com.bcxin.api.interfaces.tenants.requests.orgainzaitionAdmins.DeleteOrganizationAdminRequest;
import com.bcxin.api.interfaces.tenants.responses.OrganizationAdminResponse;
import com.bcxin.tenant.domain.readers.TenantDbReader;
import com.bcxin.tenant.domain.readers.dtos.OrganizationAdminDto;
import com.bcxin.tenant.domain.services.OrganizationAdminService;
import com.bcxin.tenant.domain.services.commands.organizationAdmins.CreateOrganizationAdminCommand;
import com.bcxin.tenant.domain.services.commands.organizationAdmins.DeleteOrganizationAdminCommand;
import org.apache.dubbo.config.annotation.DubboService;

import java.util.stream.Collectors;

@DubboService(version = ApiConstant.VERSION,validation = "true",retries = 0,timeout = 120 *1000)
public class OrganizationAdminRpcProviderImpl implements OrganizationAdminRpcProvider {
    private final OrganizationAdminService organizationAdminService;
    private final TenantDbReader dbReader;

    public OrganizationAdminRpcProviderImpl(OrganizationAdminService organizationAdminService, TenantDbReader dbReader) {
        this.organizationAdminService = organizationAdminService;
        this.dbReader = dbReader;
    }

    @Override
    public void create(String organizationId, CreateOrganizationAdminRequest request) {
        this.organizationAdminService.dispatch(
                CreateOrganizationAdminCommand.create(organizationId, request.getEmployeeIds()));
    }

    @Override
    public void delete(String organizationId,DeleteOrganizationAdminRequest request) {
        this.organizationAdminService.dispatch(DeleteOrganizationAdminCommand.create(organizationId, request.getIds()));
    }

    @Override
    public Pageable<OrganizationAdminResponse> search(String organizationId, OrganizationAdminCriteria criteria) {
        Pageable<OrganizationAdminDto> organizationAdminDtoPageable =
                this.dbReader.searchOrganAdmins(
                        com.bcxin.tenant.domain.readers.criterias.OrganizationAdminCriteria.create(
                                criteria.getKeyword(), organizationId, criteria.getPageIndex(), criteria.getPageSize()));

        return Pageable.create(organizationAdminDtoPageable.getPageIndex(), organizationAdminDtoPageable.getPageSize(),
                organizationAdminDtoPageable.getTotalCount(),
                organizationAdminDtoPageable.getData().stream().map(ix -> OrganizationAdminResponse.create(ix.getId(),
                        ix.getName(), ix.getTelephone(), ix.getDepartName())).collect(Collectors.toList())
        );
    }
}
