package com.bcxin.tenant.apis.impls;

import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.tenants.InviteOrganizationRelationshipRpcProvider;
import com.bcxin.api.interfaces.tenants.responses.CompanyUSCCResponse;
import com.bcxin.tenant.domain.repositories.InviteOrganizationRelationshipRepository;
import com.bcxin.tenant.domain.services.InviteOrganizationRelationshipService;
import org.apache.dubbo.config.annotation.DubboService;

@DubboService(version = ApiConstant.VERSION,validation = "true",retries = 0,timeout = 120_000)
public class InviteOrganizationRelationshipRpcProviderImpl implements InviteOrganizationRelationshipRpcProvider {

    private final InviteOrganizationRelationshipService inviteOrganizationRelationshipService;

    private final InviteOrganizationRelationshipRepository inviteOrganizationRelationshipRepository;

    public InviteOrganizationRelationshipRpcProviderImpl(InviteOrganizationRelationshipService inviteOrganizationRelationshipService, InviteOrganizationRelationshipRepository inviteOrganizationRelationshipRepository) {
        this.inviteOrganizationRelationshipService = inviteOrganizationRelationshipService;
        this.inviteOrganizationRelationshipRepository = inviteOrganizationRelationshipRepository;
    }


    @Override
    public String getGroupCode(String organizationId) {
        return inviteOrganizationRelationshipService.getGroupCode(organizationId);
    }

    @Override
    public CompanyUSCCResponse findCompanyUSCCByGroupCode(String groupCode) {
        return inviteOrganizationRelationshipService.findCompanyUSCCByGroupCode(groupCode);
    }
}
