package com.bcxin.tenant.apis.impls;

import com.bcxin.Infrastructures.utils.RedisUtil;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.commons.ConfigRpcProvider;
import com.bcxin.tenant.domain.entities.ConfigEntity;
import com.bcxin.tenant.domain.repositories.ConfigRepository;
import org.apache.dubbo.config.annotation.DubboService;

/**
 * <b> 字典 </b>
 * @author ZXF
 * @create 2021/12/21 0021 11:06
 * @version
 * @注意事项 </b>
 */
@DubboService(version = ApiConstant.VERSION,validation = "true",timeout = 120 *1000,retries = 0)
public class ConfigRpcProviderImpl implements ConfigRpcProvider {


    private final ConfigRepository configRepository;
    private final RedisUtil redisUtil;

    public ConfigRpcProviderImpl(ConfigRepository configRepository,RedisUtil redisUtil){
        this.configRepository = configRepository;
        this.redisUtil = redisUtil;
    }

    @Override
    public String getValueByKey(String key){
        Object result = redisUtil.get("config_"+key);
        if(result == null){
            ConfigEntity config = configRepository.getValueByKey(key);
            if(config != null){
                redisUtil.set("config_"+key,config.getConfigValue(),1800);
                return config.getConfigValue();
            }
            return null;
        }
        return result.toString();
    }

    @Override
    public String getValueByKeyNoCache(String key) {
        ConfigEntity config = configRepository.getValueByKey(key);
        if (config == null) {
            return null;
        }

        return config.getConfigValue();
    }

    @Override
    public void reload(String configKey) {
        redisUtil.del("config_"+configKey);
        getValueByKey(configKey);
    }
}
