package com.bcxin.tenant.apis.eventHandlers;

import com.bcxin.Infrastructures.events.handlers.DomainEventHandlerAbstract;
import com.bcxin.Infrastructures.utils.ExceptionUtil;
import com.bcxin.api.interfaces.backends.BackendRpfProvider;
import com.bcxin.api.interfaces.backends.requests.EventSubscriberRequest;
import com.bcxin.tenant.domain.enums.EventAction;
import com.bcxin.tenant.domain.events.TenantUserAfterCreatedEvent;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Executors;

/**
 * 新增租户用户->发送下载app短信
 */
@Slf4j
@Component
public class TenantUserAfterCreatedEvent_Handler extends DomainEventHandlerAbstract<TenantUserAfterCreatedEvent> {
    private final BackendRpfProvider backendRpfProvider;

    public TenantUserAfterCreatedEvent_Handler(BackendRpfProvider backendRpfProvider) {
        this.backendRpfProvider = backendRpfProvider;
    }

    @Override
    protected void execute(TenantUserAfterCreatedEvent event) {
        String tenantUserId = event.getData().getId();
        String tenantUserName = event.getData().getName();
        String tenantUserTelephone = event.getData().getTelephone();
        
        log.error("[TenantUserAfterCreatedEvent_Handler] 接收到用户创建事件, 用户ID: {}, 姓名: {}, 手机号: {}", 
                tenantUserId, tenantUserName, tenantUserTelephone);
        
        Collection<String> selectors = new ArrayList<>();
        selectors.add(EventAction.TenantUserAfterCreatedEventForIdentity.name());
        selectors.add(EventAction.TenantUserAfterCreatedEventForSms.name());
        
        log.error("[TenantUserAfterCreatedEvent_Handler] 准备触发后端任务, 用户ID: {}, 选择器: {}", 
                tenantUserId, selectors);
        
        Executors.newSingleThreadExecutor().execute(() -> {
            StringBuilder track = new StringBuilder();
            try {
                track.append(String.format("跟进执行TenantUserAfterCreatedEvent_Handler.execute=%s;", tenantUserId));
                log.error("[TenantUserAfterCreatedEvent_Handler] 开始调用后端任务, 用户ID: {}, 选择器: {}", 
                        tenantUserId, selectors);
                
                this.backendRpfProvider.dispatch(EventSubscriberRequest.create(selectors, tenantUserId));
                
                track.append("执行完毕");
                log.error("[TenantUserAfterCreatedEvent_Handler] 后端任务调用成功, 用户ID: {}", tenantUserId);
            } catch (Exception ex) {
                track.append(ExceptionUtil.getStackMessage(ex));
                log.error("[TenantUserAfterCreatedEvent_Handler] 后端任务调用失败, 用户ID: {}, 错误信息: {}", 
                        tenantUserId, ExceptionUtil.getStackMessage(ex), ex);
            }
        });
    }
}
