package com.bcxin.rest.web.apis.controllers;

import com.bcxin.api.interfaces.commons.CommonImportResponse;
import com.bcxin.api.interfaces.security.AttendSiteRpcProvider;
import com.bcxin.api.interfaces.security.CertificateRpcProvider;
import com.bcxin.api.interfaces.security.responses.AttendSiteResponse;
import com.bcxin.api.interfaces.tenants.requests.employees.BatchCerExcelRequest;
import com.bcxin.api.interfaces.tenants.requests.employees.BatchImportEmployeeRequest;
import com.bcxin.api.interfaces.tenants.requests.employees.BatchLeaveEmployeeExcelRequest;
import com.bcxin.rest.web.apis.ExtractDataComponent;
import com.bcxin.rest.web.apis.requests.BatchImportDataRequest;
import com.bcxin.rest.web.apis.utils.CacheUtil;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author linqinglin
 * @date 2021/12/11 0011 14:05
 */
@RestController
@RequestMapping("/organizations/{organizationId}/certificate")
public class CertificateController extends ControllerAbstract {

    public static Logger logger = LoggerFactory.getLogger(CertificateController.class);

    private final CertificateRpcProvider certificateRpcProvider;

    private final ExtractDataComponent extractDataComponent;


    public CertificateController(CertificateRpcProvider certificateRpcProvider,ExtractDataComponent extractDataComponent) {
        this.certificateRpcProvider = certificateRpcProvider;
        this.extractDataComponent = extractDataComponent;
    }


    @ApiOperation(value = "证书批量查询", response = Void.class)
    @PostMapping("/batch-query-cers")
    public ResponseEntity batchQueryCerInfos(
            HttpServletRequest servletRequest,
            @PathVariable String organizationId,
            @RequestBody BatchImportDataRequest request) {
        Collection<BatchCerExcelRequest> batchCerExcelRequests = extractDataComponent.extract(2, request.getPath(), excelMapValues ->
                translate2BatchCerExcelRequests(excelMapValues)
        );

        String filePath = certificateRpcProvider.batchQueryCerInfos(batchCerExcelRequests);
        return this.ok(filePath);
    }

    private Collection<BatchCerExcelRequest> translate2BatchCerExcelRequests(Collection<Map<Integer, String>> excelMapValues) {
        if (CollectionUtils.isEmpty(excelMapValues)) {
            return Collections.emptyList();
        }

        Collection<BatchCerExcelRequest> requests = excelMapValues.parallelStream().map(ii -> {
            String name = StringUtils.trimWhitespace(ii.get(0));
            String idNum = StringUtils.trimWhitespace(ii.get(1));

            if (StringUtils.hasLength(idNum)) {
                return BatchCerExcelRequest.create(name, idNum);
            }

            return null;
        }).filter(ii -> ii != null).collect(Collectors.toList());

        return requests;
    }

}
