package com.bcxin.rest.web.apis.caches;

import com.bcxin.Infrastructures.TenantUserContext;
import com.bcxin.Infrastructures.entities.ValueType;
import lombok.Data;

@Data
public class ExternalMemberInviteCodeCache extends ValueType {
    private String orgId;
    private String orgName;
    private String employeeId;
    private String name;
    private String groupId;
    private String groupName;

    public static ExternalMemberInviteCodeCache create(TenantUserContext.UserModel userModel,String groupId,String groupName) {
        ExternalMemberInviteCodeCache codeCache = new ExternalMemberInviteCodeCache();
        codeCache.setEmployeeId(userModel.getEmployeeId());
        codeCache.setName(userModel.getName());
        codeCache.setOrgId(userModel.getOrganId());
        codeCache.setOrgName(userModel.getOrganName());

        codeCache.setGroupId(groupId);
        codeCache.setGroupName(groupName);

        return codeCache;
    }

    public static String getInviteCodeCacheKey(String code) {
        return String.format("exInviteCode:%s", code);
    }
}
