package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.Infrastructures.enums.ApprovedStatus;
import com.bcxin.api.interfaces.ResponseAbstract;
import lombok.Getter;

import java.util.Date;
import java.text.SimpleDateFormat;

@Getter
public class OrganizationResponse extends ResponseAbstract {
    private final String id;
    private final String code;
    private final String name;
    private final String status;
    private final String industryCode;
    private final String institutionalCode;

    private final String industryName;
    private final String institutionalName;
    private final String placeOfRegister;
    private final String placeOfBusiness;
    private final String createdTime;
    private final String approveTime;
    private final String lonLatJson;
    private final String superviseRegionName;
    private final String superviseDepartName;

    public OrganizationResponse(String id,
                                String code, String name,
                                ApprovedStatus status,
                                String industryCode,
                                String industryName,
                                String institutionalCode,
                                String institutionalName,
                                String placeOfRegister, String placeOfBusiness,
                                Date createdTime,
                                Date approveTime,
                                String lonLatJson,
                                String superviseRegionName,
                                String superviseDepartName) {
        this.id = id;
        this.code = code;
        this.name = name;
        if (status == null) {
            this.status = "待审批";
        } else {
            switch (status) {
                case Passed:
                    this.status = "审批通过";
                    break;
                case NoPassed:
                    this.status = "不通过";
                    break;
                default:
                    this.status = "待审批";
                    break;
            }
        }

        this.industryCode = industryCode;
        this.industryName = industryName;
        this.institutionalCode = institutionalCode;
        this.institutionalName = institutionalName;
        this.placeOfRegister = placeOfRegister;
        this.placeOfBusiness = placeOfBusiness;

        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (createdTime == null) {
            this.createdTime = null;
        } else {
            this.createdTime = dateFormat.format(createdTime);
        }
        if (approveTime == null) {
            this.approveTime = null;
        } else {
            this.approveTime = dateFormat.format(approveTime);
        }

        this.lonLatJson = lonLatJson;
        this.superviseRegionName = superviseRegionName;
        this.superviseDepartName = superviseDepartName;
    }

    public static OrganizationResponse create(String id,
                                              String code, String name,
                                              ApprovedStatus status,
                                              String industryCode,
                                              String industryName,
                                              String institutionalCode,
                                              String institutionalName,
                                              String placeOfRegister, String placeOfBusiness,
                                              Date createdTime,
                                              Date approveTime,
                                              String lonLatJson,
                                              String superviseRegionName,
                                              String superviseDepartName) {
        return new OrganizationResponse(
                id, code, name,  status,
                industryCode,industryName, institutionalCode, institutionalName,
                placeOfRegister, placeOfBusiness,createdTime,approveTime,lonLatJson,superviseRegionName,superviseDepartName);
    }
}
