package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.Infrastructures.enums.InviteType;
import com.bcxin.Infrastructures.enums.RelationshipsStatus;
import com.bcxin.api.interfaces.ResponseAbstract;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;

import javax.persistence.Column;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import java.sql.Timestamp;
@ApiModel("集团组织关系详细信息")
@Getter
public class OrganizationRelationshipResponse extends ResponseAbstract {

    @ApiModelProperty("id")
    private final long id;

    @ApiModelProperty("上级组织ID")
    private final String parentId;

    @ApiModelProperty("上级组织名称")
    private final String parentName;

    @ApiModelProperty("选中的组织ID")
    private final String selectedOrganizationId;

    @ApiModelProperty("选中的组织名称")
    private final String selectedOrganizationName;

    @ApiModelProperty("组织编码")
    private final String code;

    @ApiModelProperty("联系人姓名")
    private final String contactName;

    @ApiModelProperty("联系人电话")
    private final String contactTelephone;

    @ApiModelProperty("组织类型")
    private final OrganizationTypeResponse organizationType;

    @ApiModelProperty("组织关系索引树")
    private final String relationshipIndexTree;

    @ApiModelProperty("组织关系状态")
    private final Integer status;

    @ApiModelProperty(value = "回复的备注")
    private final String lastReplyNote;

    @ApiModelProperty(value = "回复人Id")
    private final String lastReplyEmployeeId;

    @ApiModelProperty(value = "回复人姓名")
    private final String lastReplyEmployeeName;

    @ApiModelProperty(value = "最后回复时间")
    private final Timestamp lastReplyTime;

    @ApiModelProperty(value = "集团组织的Id")
    private final String organizationId;

    @ApiModelProperty(value = "创建时间")
    private final Timestamp createTime;

    @ApiModelProperty(value = "创建人Id")
    private final String creatorId;

    @ApiModelProperty(value = "最后更新时间")
    private final Timestamp lastUpdateTime;

    @ApiModelProperty(value = "邀请类型")
    private final InviteType inviteType;

    @ApiModelProperty(value = "统一社会信用代码")
    private final String unifySocialCreditCode;

    @ApiModelProperty(value = "组织成员数量")
    private final int countOfMembers;


    public OrganizationRelationshipResponse(long id, String parentId, String parentName, String selectedOrganizationId, String selectedOrganizationName, String code, String contactName, String contactTelephone, OrganizationTypeResponse organizationType, String relationshipIndexTree, Integer status, String lastReplyNote, String lastReplyEmployeeId, String lastReplyEmployeeName, Timestamp lastReplyTime, String organizationId, Timestamp createTime, String creatorId, Timestamp lastUpdateTime, InviteType inviteType, String unifySocialCreditCode, int countOfMembers) {
        this.id = id;
        this.parentId = parentId;
        this.parentName = parentName;
        this.selectedOrganizationId = selectedOrganizationId;
        this.selectedOrganizationName = selectedOrganizationName;
        this.code = code;
        this.contactName = contactName;
        this.contactTelephone = contactTelephone;
        this.organizationType = organizationType;
        this.relationshipIndexTree = relationshipIndexTree;
        this.status = status;
        this.lastReplyNote = lastReplyNote;
        this.lastReplyEmployeeId = lastReplyEmployeeId;
        this.lastReplyEmployeeName = lastReplyEmployeeName;
        this.lastReplyTime = lastReplyTime;
        this.organizationId = organizationId;
        this.createTime = createTime;
        this.creatorId = creatorId;
        this.lastUpdateTime = lastUpdateTime;
        this.inviteType = inviteType;
        this.unifySocialCreditCode = unifySocialCreditCode;
        this.countOfMembers = countOfMembers;
    }
    public static OrganizationRelationshipResponse create(long id, String parentId, String parentName,
                                                          String selectedOrganizationId,
                                                          String selectedOrganizationName, String code, String contactName, String contactTelephone, OrganizationTypeResponse organizationType, String relationshipIndexTree, Integer status, String lastReplyNote, String lastReplyEmployeeId, String lastReplyEmployeeName, Timestamp lastReplyTime, String organizationId, Timestamp createTime, String creatorId, Timestamp lastUpdateTime, InviteType inviteType, String unifySocialCreditCode, int countOfMembers) {
        return new OrganizationRelationshipResponse(id, parentId, parentName, selectedOrganizationId, selectedOrganizationName, code, contactName, contactTelephone, organizationType, relationshipIndexTree, status, lastReplyNote, lastReplyEmployeeId, lastReplyEmployeeName, lastReplyTime, organizationId, createTime, creatorId, lastUpdateTime, inviteType,unifySocialCreditCode,countOfMembers);

    }

}
