package com.bcxin.api.interfaces.tenants.responses;


import com.bcxin.api.interfaces.ResponseAbstract;
import lombok.Getter;

import java.util.Collection;

@Getter
public class OrganizationAppGetResponse extends ResponseAbstract {
    private final String id;
    private final Collection<String> appIds;

    public OrganizationAppGetResponse(String id, Collection<String> appIds) {
        this.id = id;
        this.appIds = appIds;
    }

    public static OrganizationAppGetResponse create(String id, Collection<String> appIds) {
        return new OrganizationAppGetResponse(id, appIds);
    }
}
