package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.Infrastructures.enums.MemberType;
import com.bcxin.Infrastructures.enums.OrganizationLevel;
import com.bcxin.Infrastructures.enums.OrganizationResourceType;
import com.bcxin.Infrastructures.utils.JwtUtil;
import com.bcxin.api.interfaces.ResponseAbstract;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@ApiModel("当前的团队信息")
@Getter
public class MyTeamGetResponse extends ResponseAbstract {
    @ApiModelProperty("组织id")
    private final String id;
    @ApiModelProperty("组织名称")
    private final String name;
    @ApiModelProperty("行业编码")
    private final String industryCode;
    @ApiModelProperty("机构编码")
    private final String institutionalCode;
    @ApiModelProperty("职员的凭证")
    private final String accessToken;
    @ApiModelProperty("所属区域")
    private final String areaCode;
    @ApiModelProperty("是否组织管理员")
    private final boolean isDomainAdmin;
    @ApiModelProperty("是否职员(true=职员;false=赛演人员的非员工);非员工不允许查看团队信息")
    private final boolean isEmployee;

    @ApiModelProperty("企业的资源信息: 资源类型")
    private final OrganizationResourceType resourceType;

    @ApiModelProperty("企业的资源信息: Employee的时候表示employeeId, 否则为MemberId")
    private final String resourceNumber;

    private final Collection<OrganizationLevel> organizationLevels;

    private List<String> permissions = new ArrayList<>();

    public MyTeamGetResponse(String id, String name, String industryCode, String institutionalCode,
                             OrganizationResourceType resourceType,
                             String resourceNumber,
                             String areaCode, boolean isDomainAdmin,
                             Collection<OrganizationLevel> organizationLevels) {
        this.id = id;
        this.name = name;
        this.industryCode = industryCode;
        this.institutionalCode = institutionalCode;
        this.resourceNumber = resourceNumber;
        this.resourceType = resourceType;
        this.areaCode = areaCode;
        this.isDomainAdmin = isDomainAdmin;
        this.organizationLevels = organizationLevels;
        this.isEmployee = (resourceType == OrganizationResourceType.Employee);
        this.accessToken = JwtUtil.getToken(resourceNumber);
    }

    public static MyTeamGetResponse create(String id, String name,
                                           String industryCode, String institutionalCode,
                                           OrganizationResourceType resourceType,
                                           String resourceNumber,
                                           String areaCode,
                                           MemberType memberType,
                                           Collection<OrganizationLevel> organizationLevels) {
        return new MyTeamGetResponse(
                id, name, industryCode, institutionalCode, resourceType, resourceNumber,
                areaCode, memberType == MemberType.Master, organizationLevels
        );
    }
}
