package com.bcxin.api.interfaces.tenants.requests.tenantUsers;

import com.bcxin.Infrastructures.enums.Sex;
import com.bcxin.api.interfaces.RequestAbstract;
import com.bcxin.api.interfaces.tenants.requests.organizations.LocationRequest;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
public class UpdateTenantUserRequest extends RequestAbstract {
    @ApiModelProperty(value = "头像")
    private String headPhoto;

    @ApiModelProperty(value = "性别")
    private Sex sex;

    @ApiModelProperty(value = "民族")
    private String nation;

    @ApiModelProperty(value = "从业年限")
    private String workYear;

    @ApiModelProperty(value = "疾病历史")
    private String diseasesHistory;

    @ApiModelProperty(value = "政治面貌")
    private String politicsStatus;

    @ApiModelProperty(value = "身高", example = "180cm")
    private String stature;

    @ApiModelProperty(value = "兵役情况")
    private String militaryStatus;

    @ApiModelProperty(value = "出生日期", example = "1990-01-01", dataType = "String")
    private Date birthdate;

    @ApiModelProperty(value = "文化程度")
    private String education;

    @ApiModelProperty(value = "户籍类型")
    private String householdType;

    @ApiModelProperty(value = "籍贯")
    private String nativePlace;

    @ApiModelProperty(value = "婚姻状况")
    private String maritalStatus;

    @ApiModelProperty(value = "邮箱")
    private String email;

    /**
     * 紧急联系人
     */
    @ApiModelProperty(value = "紧急联系人")
    private String emergencyContact;

    /**
     * 紧急联系人电话
     */
    @ApiModelProperty(value = "紧急联系人电话")
    private String emergencyPhone;

    /**
     * 驾照等级
     */
    @ApiModelProperty(value = "驾照等级")
    private String licenseLevel;

    /**
     * 现住地址
     */
    @ApiModelProperty(value = "现住地址")
    private LocationRequest placeOfNow;

}
