package com.bcxin.api.interfaces.tenants.requests.organizationType;

import com.bcxin.api.interfaces.RequestAbstract;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@ApiModel("修改集团组织类型请求对象")
@Data
public class OrganizationTypeUpdateRequest extends RequestAbstract {

    @ApiModelProperty(value = "id", required = true)
    @NotNull(message = "id不能为空")
    private long id;

    @ApiModelProperty(value = "集团组织类型名称")
    private String name;

    @ApiModelProperty(value = "集团组织类型备注")
    private String note;

    @ApiModelProperty(value = "所属组织")
    private String organizationId;

}
