package com.bcxin.api.interfaces.tenants.requests.organizationRelationship;

import com.bcxin.Infrastructures.enums.RelationshipsStatus;
import com.bcxin.api.interfaces.RequestAbstract;
import lombok.Data;

import java.util.Collection;

@Data
public class OrganizationStructureQueryRequest extends RequestAbstract {
    private Collection<RelationshipsStatus> statuses;

    private String organizationID;

    public static OrganizationStructureQueryRequest create(String organizationID, Collection<RelationshipsStatus> statuses){
        OrganizationStructureQueryRequest request = new OrganizationStructureQueryRequest();
        request.setOrganizationID(organizationID);
        request.setStatuses(statuses);
        return request;
    }
}
