package com.bcxin.api.interfaces.tenants.requests.employees;

import com.bcxin.Infrastructures.enums.OccupationType;
import lombok.Getter;

import java.io.Serializable;
import java.util.Date;

@Getter
public class BackEmployeeRequest implements Serializable {
    private final String id;
    private final String departId;
    private final OccupationType occupationType;
    private final Date hiredDate;

    public BackEmployeeRequest(String id, String departId, OccupationType occupationType, Date hiredDate) {
        this.id = id;
        this.departId = departId;
        this.occupationType = occupationType;
        this.hiredDate = hiredDate;
    }

    public static BackEmployeeRequest create(String id, String departId, OccupationType occupationType, Date hiredDate) {
        return new BackEmployeeRequest(id, departId, occupationType, hiredDate);
    }
}
