package com.bcxin.api.interfaces.tenants;

import com.bcxin.Infrastructures.Pageable;
import com.bcxin.api.interfaces.commons.CommonImportResponse;
import com.bcxin.api.interfaces.tenants.criterias.EmployeeCriteria;
import com.bcxin.api.interfaces.tenants.criterias.EmployeeLeaveCriteria;
import com.bcxin.api.interfaces.tenants.requests.employees.*;
import com.bcxin.api.interfaces.tenants.requests.tenantUsers.IMContactCriteria;
import com.bcxin.api.interfaces.tenants.responses.*;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.List;

@Component
public interface EmployeeRpcProvider {
    String create(String organizationId, EmployeeRequest request);

    void update(String organizationId, String id, UpdateEmployeeRequest request);

    Pageable<EmployeeGetResponse> find(String organizationId, EmployeeCriteria criteria);

    Collection<MyImContactGetResponse> getMyImContacts(IMContactCriteria request);

    Collection<MyImContactGetResponse> getMyImContactSearch(IMContactCriteria request);

    Collection<MyImDepartGetResponse> getMyImDeparts(String organizationId, String tenantUserId);

    void batchMove(String organizationId, BatchMoveEmployeesRequest request);

    CommonImportResponse batchImport(String organizationId, String institutionalCode, String path, Collection<BatchImportEmployeeRequest> requests);

    void batchLeave(String organizationId, BatchLeaveEmployeeRequest request);

    CommonImportResponse batchLeaveExcel(String organizationId,String path, Collection<BatchLeaveEmployeeExcelRequest> request);

    void batchAssignSuperiors(String organizationId, BatchAssignEmployeeSuperiorRequest request);

    /**
     * 复职:
     * 验证:
     * 1, 是否存在同一个区域有多种职业类型
     * @param organizationId
     * @param request
     */
    void back(String organizationId, BackEmployeeRequest request);

    Pageable<EmployeeLeaveGetResponse> findLeaves(String organizationId, EmployeeLeaveCriteria criteria);

    void batchPermissions(String organizationId, BatchPermissionRequest request);

    AppRolePermissionResponse getPermissions(String organizationId, String id);

    void clearPermissions(String organizationId, String id);

    EmployeeDetailGetResponse getByOrganIdAndId(String organizationId, String id);

    Collection<AppRolePermissionResponse> getBatchPermissions(String organizationId, Collection<String> ids);

    InviteUserGetResponse getByOrganIdAndPhone(String organizationId, String telephone);

    InviteUserGetResponse getByOrganIdAndIdNum(String organizationId, String idNum);

    String createExcel(String organizationId, EmployeeCriteria criteria);

    List<ColumnResponse> getExportColumns();

    String createLeaveExcel(String organizationId, EmployeeLeaveCriteria criteria, String industryCode);

    String createLeaveWord(String organizationId,String id);

    EmployeeReportResponse findReport(String organizationId, EmployeeCriteria criteria);

    EmployeeBasicResponse getEmployeeBasic(String organizationId, String id);

    Pageable<ImContactResponse> contactSearch(IMContactCriteria request);
    Collection<OrganizationAdminResponse> getOrganizationAdministrators(String organizationId);
}
