package com.bcxin.api.interfaces.rbacs.requests;

import com.bcxin.api.interfaces.RequestAbstract;
import lombok.Getter;

import java.util.Collection;

@Getter
public class CreateRoleRequest extends RequestAbstract {
    private final String name;
    private final Collection<ResourceItemRequest> resources;

    public CreateRoleRequest(String name, Collection<ResourceItemRequest> resources) {
        this.name = name;
        this.resources = resources;
    }

    public static CreateRoleRequest create(String name,
                                           Collection<ResourceItemRequest> resources) {
        return new CreateRoleRequest(name, resources);
    }
}
