package com.bcxin.api.interfaces.rbacs.custom.response;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.serializer.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@ApiModel("企业授权应用返回对象")
@Data
public class RbacPermitAppResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "应用ID")
    @JSONField(serializeUsing = ToStringSerializer.class)
    private Long appId;

    @ApiModelProperty(value = "应用代码")
    private String appCode;

    @ApiModelProperty(value = "应用名称")
    private String appName;

    @ApiModelProperty(value = "应用logo")
    private String appLogo;

    @ApiModelProperty(value = "应用分类")
    private String category;

    @ApiModelProperty(value = "是否勾选，1是，0否")
    private Integer checked = 0;

    @ApiModelProperty(value = "应用子节点列表")
    private List<RbacPermitAppResponse> children;

    @ApiModelProperty(value = "操作项列表")
    List<RbacPermitOptionResponse> optionList;

}
