package com.bcxin.api.interfaces.rbacs.custom.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@ApiModel("功能授权对象")
@Data
public class RbacPermitAuthRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "企业id", hidden = true)
    private String organizationId;

    @ApiModelProperty(value = "职员id列表（单独给职员授权的时候传）")
    private List<String> employeeIdList;

    @ApiModelProperty(value = "角色id(单独给角色授权的时候传)")
    private Long roleId;

    @ApiModelProperty(value = "授权应用列表")
    private List<RbacPermitAppAuthRequest> appList;

}
