package com.bcxin.api.interfaces.rbacs.custom.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@ApiModel("自定义角色编辑对象")
@Data
public class RbacCustomRoleEditRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "角色id")
    @NotNull(message = "角色id不能为空")
    private Long id;

    @ApiModelProperty(value = "企业id", hidden = true)
    private String organizationId;

    @ApiModelProperty(value = "角色名称", required = true)
    @NotBlank(message = "角色名称不能为空")
    private String roleName;

    @ApiModelProperty(value = "备注说明")
    private String remark;

    @ApiModelProperty(value = "排序")
    @NotNull(message = "排序不能为空")
    private Integer seq;

}
