package com.bcxin.api.interfaces.identities.requests;

import cn.hutool.core.date.DateUtil;
import cn.hutool.crypto.digest.DigestUtil;
import com.bcxin.api.interfaces.RequestAbstract;
import lombok.Data;

import javax.validation.constraints.NotEmpty;


@Data
public class XlcpCallRequest extends RequestAbstract {

    @NotEmpty
    private String company_id;//企业id
    @NotEmpty
    private String emp_id;//雇员id
    @NotEmpty
    private String serial_number;//业务编码
    @NotEmpty
    private String project_name;//测评项目名称
    @NotEmpty
    private String file_url;//附件
    private String suggestion;//建议
    private String content;//评语
    private String result;//测评结果
    private String result_rule_tip;//结果规则提示
    @NotEmpty
    private String sign;
    @NotEmpty
    private String random_key;

    public boolean isAuth() {
        // 企业id+日期+雇员id+随机数
        String token = DigestUtil.md5Hex(this.project_name + this.company_id + DateUtil.today() + this.emp_id + this.random_key);
        return token.equals(this.sign);
    }
}
