package com.bcxin.api.interfaces.identities.requests;

import com.bcxin.api.interfaces.buses.enums.SmsBusinessType;
import lombok.Data;

@Data
public class SmsRequest extends PasswordRequestAbstract {
    private SmsBusinessType businessType;
    private String phone;
    private String code;

    public SmsRequest(){}

    public SmsRequest(SmsBusinessType businessType,String phone){
        this.businessType = businessType;
        this.phone = phone;
    }

    public SmsRequest(SmsBusinessType businessType,String phone,String code){
        this.businessType = businessType;
        this.phone = phone;
        this.code = code;
    }

    public SmsRequest(String phone,String code){
        this.phone = phone;
        this.code = code;
    }

    public static SmsRequest create(SmsBusinessType businessType,String phone){
        return new SmsRequest(businessType,phone);
    }

    public static SmsRequest create(String phone,String code){
        return new SmsRequest(phone,code);
    }
}
