package com.bcxin.identity.api.eventhandlers;

import com.bcxin.Infrastructures.events.handlers.DomainEventHandlerAbstract;
import com.bcxin.api.interfaces.tenants.UserRpcProvider;
import com.bcxin.api.interfaces.tenants.requests.tenantUsers.SyncWechatLabelRequest;
import com.bcxin.identity.domains.events.IdentityUser_WechatBindEvent;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class IdentityUser_WechatBindEvent_Handler extends DomainEventHandlerAbstract<IdentityUser_WechatBindEvent>
{
    private final ThreadPoolTaskExecutor taskExecutor;
    private final UserRpcProvider userRpcProvider;

    public IdentityUser_WechatBindEvent_Handler(ThreadPoolTaskExecutor taskExecutor,
                                                UserRpcProvider userRpcProvider) {
        this.taskExecutor = taskExecutor;
        this.userRpcProvider = userRpcProvider;
    }

    @Override
    protected void execute(IdentityUser_WechatBindEvent event) {
        this.taskExecutor.execute(() -> {
            this.userRpcProvider.syncWechatLabel(event.getTenantUserId(),
                    SyncWechatLabelRequest.create(event.getOpenId(), event.getNicky()));
        });
    }
}
