/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.rbac.domain.v5.repository;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="v5.config")
public class V5ConfigProperty {
    private static final String APP_META_URI_TEMPLATE = "[[website]]/obpm/api/authtime/domain/[[domainId]]/applications/bind?_currpage=1&_pagelines=10000";
    private static final String ROLE_META_URI_TEMPLATE = "[[website]]/obpm/api/authtime/application/[[appId]]/roles?currpage=1&pagelines=10000";
    private static final String MODULE_META_URI_TEMPLATE = "[[website]]/designer/api/designtime/applications/[[appId]]/modules?parentId=[[parentModuleId]]";
    private static final String PERMISSION_META_URI_TEMPLATE = "[[website]]/designer/api/designtime/applications/[[appId]]/modules/[[moduleId]]/permissions?roleId=";
    private String website;

    public String getAppMetaUri(String domainId) {
        return APP_META_URI_TEMPLATE.replace("[[website]]", this.website).replace("[[domainId]]", domainId);
    }

    public String getRoleMetaUri(String appId) {
        return ROLE_META_URI_TEMPLATE.replace("[[website]]", this.website).replace("[[appId]]", appId);
    }

    public String getModuleMetaUri(String appId, String parentModuleId) {
        return MODULE_META_URI_TEMPLATE.replace("[[website]]", this.website).replace("[[appId]]", appId).replace("[[parentModuleId]]", parentModuleId);
    }

    public String getPermissionMetaUri(String appId, String moduleId) {
        return PERMISSION_META_URI_TEMPLATE.replace("[[website]]", this.website).replace("[[appId]]", appId).replace("[[moduleId]]", moduleId);
    }
}

