/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.rbac.domain.repository;

import com.bcxin.Infrastructures.entities.OperatorValueType;
import com.bcxin.rbac.domain.RbacDbReader;
import com.bcxin.rbac.domain.dtos.CategoryTreeDto;
import com.bcxin.rbac.domain.dtos.ResourceDto;
import com.bcxin.rbac.domain.dtos.RoleDetailDto;
import com.bcxin.rbac.domain.dtos.RoleDto;
import com.bcxin.rbac.domain.dtos.UserDetailDto;
import com.bcxin.rbac.domain.repository.tmps.CategoryResourceTmpDto;
import com.bcxin.rbac.domain.repository.tmps.ResourceTmpDto;
import com.bcxin.rbac.domain.repository.tmps.RoleResourceTmpDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Repository
public class RbacDbReaderImpl
implements RbacDbReader {
    private final EntityManager entityManager;

    public RbacDbReaderImpl(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public Collection<ResourceDto> getAllTreeResources(String categoryId) {
        TypedQuery resourceTmpDtoTypedQuery = this.entityManager.createQuery("select new com.bcxin.rbac.domain.repository.tmps.ResourceTmpDto(d.id,d.category.id,d.name,d.data,d.dataType,d.metaId,d.metaConfig,d.metaData,d.level,d.parent.id, d.creator,d.lastModifier)  from ResourceEntity d where d.category.id=?1", ResourceTmpDto.class);
        resourceTmpDtoTypedQuery.setParameter(1, (Object)categoryId);
        List resourceTmps = resourceTmpDtoTypedQuery.getResultList();
        if (resourceTmps.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        int minLevel = resourceTmps.stream().map(ii -> ii.getLevel()).min(Integer::compare).get();
        Collection rootResources = resourceTmps.stream().filter(ii -> ii.getLevel() == minLevel).map(ii -> ResourceDto.create((String)ii.getId(), (String)ii.getCategoryId(), (String)ii.getName(), (String)ii.getData(), (String)ii.getDataType(), (String)ii.getMetaId(), (String)ii.getMetaConfig(), (String)ii.getMetaData(), (OperatorValueType)ii.getCreator(), (OperatorValueType)ii.getLastModifier())).collect(Collectors.toList());
        rootResources.forEach(ii -> this.buildChildResources((ResourceDto)ii, resourceTmps));
        return rootResources;
    }

    public RoleDetailDto getRoleById(String subjectId, String id) {
        TypedQuery roleQuery = this.entityManager.createQuery("select new map(r.id as roleId, r.name as roleName,c.id as resourceId,c.code as resourceCode, c.name as resourceName, c.parent.id as resourceParentId,c.treePathId as resourceTreePathId,c.code as resourceCode,c.data as resourceData,c.dataType as resourceDataType,c.level as resourceLevel)  from RoleEntity r left join r.resources c where r.subject.id=?1 and r.id=?2", Map.class);
        roleQuery.setParameter(1, (Object)subjectId);
        roleQuery.setParameter(2, (Object)id);
        List roleRelationData = roleQuery.getResultList();
        if (roleRelationData.size() == 0) {
            return null;
        }
        RoleDetailDto roleDetailDto = null;
        ArrayList<RoleResourceTmpDto> roleResourceTmpDtos = new ArrayList<RoleResourceTmpDto>();
        for (Map map : roleRelationData) {
            if (roleDetailDto == null) {
                roleDetailDto = RoleDetailDto.create((String)((String)map.get("roleId")), (String)((String)map.get("roleName")));
            }
            if (map.get("resourceId") == null) continue;
            roleResourceTmpDtos.add(RoleResourceTmpDto.create((String)map.get("resourceId"), (String)map.get("resourceCode"), (String)map.get("resourceName"), (String)map.get("resourceData"), (String)map.get("resourceDataType"), (String)map.get("resourceParentId"), (String)map.get("treePathId"), (Integer)map.get("resourceLevel"), (String)map.get("roleId")));
        }
        Collection rootResourceTmps = roleResourceTmpDtos.stream().filter(ii -> !roleResourceTmpDtos.stream().anyMatch(ix -> ix.getParentId().equals(ii.getId()))).collect(Collectors.toList());
        for (RoleResourceTmpDto rt : rootResourceTmps) {
            RoleDetailDto.RoleSelectedResourceDto newRoleDetailDto = RoleDetailDto.RoleSelectedResourceDto.create((String)rt.getId(), (String)rt.getCode(), (String)rt.getName(), (String)rt.getTreePathId());
            roleDetailDto.addSelectedResource(newRoleDetailDto);
            this.buildRoleResource(newRoleDetailDto, roleResourceTmpDtos);
        }
        return roleDetailDto;
    }

    public Collection<RoleDto> getAllRoles(String subjectId) {
        TypedQuery roleDtoTypedQuery = this.entityManager.createQuery("select new com.bcxin.rbac.domain.dtos.RoleDto(d.id,d.name)  from RoleEntity d where d.subject.id=?1", RoleDto.class);
        roleDtoTypedQuery.setParameter(1, (Object)subjectId);
        return roleDtoTypedQuery.getResultList();
    }

    public UserDetailDto getUserDetailById(String subjectId, String id) {
        TypedQuery roleQuery = this.entityManager.createQuery("select new map(u.id as userId, u.name as userName, u.referencedId as uReferencedId, r.id as roleId, r.name as roleName,c.id as resourceId,c.code as resourceCode, c.name as resourceName, c.parent.id as resourceParentId,c.treePathId as resourceTreePathId,c.code as resourceCode,c.data as resourceData,c.dataType as resourceDataType,c.level as resourceLevel)  from UserEntity u left join u.roles r left join r.resources c where u.subject.id=?1 and u.id=?2", Map.class);
        roleQuery.setParameter(2, (Object)id);
        roleQuery.setParameter(1, (Object)subjectId);
        List roleRelationData = roleQuery.getResultList();
        if (roleRelationData.size() == 0) {
            return null;
        }
        UserDetailDto userDetailDto = null;
        ArrayList<RoleResourceTmpDto> roleResourceTmpDtos = new ArrayList<RoleResourceTmpDto>();
        for (Map map : roleRelationData) {
            if (userDetailDto == null) {
                userDetailDto = UserDetailDto.create((String)((String)map.get("userId")), (String)((String)map.get("userName")), (String)((String)map.get("uReferencedId")));
            }
            if (map.get("roleId") == null) continue;
            String roleId = (String)map.get("roleId");
            Optional<RoleDetailDto> roleDetailDtoOptional = userDetailDto.getRoleDetails().stream().filter(ii -> ii.getId().equals(roleId)).findFirst();
            RoleDetailDto roleDetailDto = null;
            if (roleDetailDtoOptional.isPresent()) {
                roleDetailDto = roleDetailDtoOptional.get();
            }
            if (roleDetailDto == null) {
                roleDetailDto = RoleDetailDto.create((String)((String)map.get("roleId")), (String)((String)map.get("roleName")));
                userDetailDto.assignRoleDetail(roleDetailDto);
            }
            if (map.get("resourceId") == null) continue;
            roleResourceTmpDtos.add(RoleResourceTmpDto.create((String)map.get("resourceId"), (String)map.get("resourceCode"), (String)map.get("resourceName"), (String)map.get("resourceData"), (String)map.get("resourceDataType"), (String)map.get("resourceParentId"), (String)map.get("treePathId"), (Integer)map.get("resourceLevel"), roleId));
        }
        for (RoleDetailDto selectedRoleDetail : userDetailDto.getRoleDetails()) {
            Collection rootResourceTmps = roleResourceTmpDtos.stream().filter(ii -> !roleResourceTmpDtos.stream().anyMatch(ix -> selectedRoleDetail.getId().equals(ix.getRoleId()) && ix.getParentId().equals(ii.getId()))).collect(Collectors.toList());
            for (RoleResourceTmpDto rt : rootResourceTmps) {
                RoleDetailDto.RoleSelectedResourceDto newRoleDetailDto = RoleDetailDto.RoleSelectedResourceDto.create((String)rt.getId(), (String)rt.getCode(), (String)rt.getName(), (String)rt.getTreePathId());
                selectedRoleDetail.addSelectedResource(newRoleDetailDto);
                this.buildRoleResource(newRoleDetailDto, roleResourceTmpDtos);
            }
        }
        return userDetailDto;
    }

    public Collection<CategoryTreeDto> getTreeCategories(Collection<String> categoryIds) {
        return this.getCategoryTreeDtosByIds(categoryIds);
    }

    public Collection<CategoryTreeDto> getAllTreeCategories() {
        return this.getCategoryTreeDtosByIds(null);
    }

    private void buildChildResources(ResourceDto parent, Collection<ResourceTmpDto> allResources) {
        Collection selectedResources = allResources.stream().filter(ii -> StringUtils.hasLength((String)ii.getParentId()) && ii.getParentId().equals(parent.getId())).map(ii -> ResourceDto.create((String)ii.getId(), (String)ii.getCategoryId(), (String)ii.getName(), (String)ii.getData(), (String)ii.getDataType(), (String)ii.getMetaId(), (String)ii.getMetaConfig(), (String)ii.getMetaData(), (OperatorValueType)ii.getCreator(), (OperatorValueType)ii.getLastModifier())).collect(Collectors.toList());
        for (ResourceDto resourceDto : selectedResources) {
            this.buildChildResources(resourceDto, allResources);
            parent.addChildResource(resourceDto);
        }
    }

    private void buildRoleResource(RoleDetailDto.RoleSelectedResourceDto roleSelectedResourceDto, Collection<RoleResourceTmpDto> allResourceTmpDtos) {
        Collection selectedResourceTmps = allResourceTmpDtos.stream().filter(ii -> StringUtils.hasLength((String)ii.getParentId()) && ii.getParentId().equals(roleSelectedResourceDto.getId())).collect(Collectors.toList());
        for (RoleResourceTmpDto rt : selectedResourceTmps) {
            RoleDetailDto.RoleSelectedResourceDto newRoleDetailDto = RoleDetailDto.RoleSelectedResourceDto.create((String)rt.getId(), (String)rt.getCode(), (String)rt.getName(), (String)rt.getTreePathId());
            roleSelectedResourceDto.addChildResource(newRoleDetailDto);
            this.buildRoleResource(newRoleDetailDto, allResourceTmpDtos);
        }
    }

    public Collection<CategoryTreeDto> getCategoryTreeDtosByIds(Collection<String> categoryIds) {
        String qString = "select new com.bcxin.rbac.domain.repository.tmps.CategoryResourceTmpDto(c.id,c.name,d.id,d.name,d.data,d.dataType,d.metaId,d.metaConfig,d.metaData,d.level,d.parent.id, d.creator,d.lastModifier)  from ResourceEntity d join d.category c ";
        HashMap<Integer, Collection<String>> parameters = new HashMap<Integer, Collection<String>>();
        if (!CollectionUtils.isEmpty(categoryIds)) {
            qString = "select new com.bcxin.rbac.domain.repository.tmps.CategoryResourceTmpDto(c.id,c.name,d.id,d.name,d.data,d.dataType,d.metaId,d.metaConfig,d.metaData,d.level,d.parent.id, d.creator,d.lastModifier)  from ResourceEntity d join d.category c where c.id in (?1)";
            parameters.put(1, categoryIds);
        }
        TypedQuery categoryResourceTmpDtoTypedQuery = this.entityManager.createQuery(qString, CategoryResourceTmpDto.class);
        for (Integer key : parameters.keySet()) {
            categoryResourceTmpDtoTypedQuery.setParameter(key.intValue(), parameters.get(key));
        }
        List categoryResourceTmps = categoryResourceTmpDtoTypedQuery.getResultList();
        if (categoryResourceTmps.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<CategoryTreeDto> categoryTreeDtos = new ArrayList<CategoryTreeDto>();
        for (CategoryResourceTmpDto crdt : categoryResourceTmps) {
            Optional<CategoryTreeDto> selectedCategoryOptional = categoryTreeDtos.stream().filter(ii -> ii.getId().equals(crdt.getCategoryId())).findFirst();
            CategoryTreeDto selectedCategory = null;
            if (selectedCategoryOptional.isPresent()) continue;
            selectedCategory = new CategoryTreeDto(crdt.getCategoryId(), crdt.getCategoryName(), crdt.getCategoryName());
            categoryTreeDtos.add(selectedCategory);
        }
        categoryTreeDtos.forEach(ctd -> {
            Collection resourceTmps = categoryResourceTmps.stream().filter(ii -> ii.getCategoryId().equals(ctd.getId())).collect(Collectors.toList());
            int minLevel = resourceTmps.stream().map(ii -> ii.getLevel()).min(Integer::compare).get();
            Collection rootResources = resourceTmps.stream().filter(ii -> ii.getLevel() == minLevel).map(ii -> ResourceDto.create((String)ii.getId(), (String)ii.getCategoryId(), (String)ii.getName(), (String)ii.getData(), (String)ii.getDataType(), (String)ii.getMetaId(), (String)ii.getMetaConfig(), (String)ii.getMetaData(), (OperatorValueType)ii.getCreator(), (OperatorValueType)ii.getLastModifier())).collect(Collectors.toList());
            rootResources.forEach(ii -> this.buildChildResources((ResourceDto)ii, resourceTmps));
            ctd.assignResources(rootResources);
        });
        return categoryTreeDtos;
    }
}

