package com.bcxin.tenant.domain.v5.snapshots.dataexchanges;

import com.bcxin.Infrastructures.enums.OrganizationsStatus;
import com.bcxin.tenant.domain.entities.CompanyEntity;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;

@Getter
@Setter(AccessLevel.PROTECTED)
public class DomainValueSnapshot extends ValueSnapshot {

    private String id;

    //公司名称
    private String name;
    //组织统一社会信用代码
    private String organizeCode;
    //统一社会信用代码证扫描件
    private String certificate;
    //状态
    private OrganizationsStatus status;

    //注册地址
    private String registeredAddress;
    private String registeredAddressDetail;
    //注册地址code
    private String placeOfRegisterProvinceCode;
    private String placeOfRegisterCityCode;
    private String placeOfRegisterDistrictCode;
    //注册地址name
    private String placeOfRegisterProvinceName;
    private String placeOfRegisterCityName;
    private String placeOfRegisterDistrictName;

    //经营地址
    private String organizedAddress;
    private String organizedAddressDetail;
    //经营地址code
    private String placeOfBusinessProvinceCode;
    private String placeOfBusinessCityCode;
    private String placeOfBusinessDistrictCode;
    //经营地址name
    private String placeOfBusinessProvinceName;
    private String placeOfBusinessCityName;
    private String placeOfBusinessDistrictName;


    //行业类型
    private String industryCode;
    //机构类型
    private String institutionalCode;
    //保安服务公司类型", notes = "com.bcxin.Infrastructures.enums.IndustryDetailType
    private Integer industryDetailType;

    //基本信息
    //总/分/子公司", notes = "com.bcxin.Infrastructures.enums.ParentSubsidiary
    private Integer type;
    //联系电话
    private String telephone;
    //传真
    private String fax;
    //经济类型", notes = "com.bcxin.Infrastructures.enums.EconomicType
    private Integer economicType;
    //公司类型", notes = "com.bcxin.Infrastructures.enums.CompanyNature
    private Integer nature;

    //总公司信息，保安行业必填
    //总公司名称
    private String parentName;
    //总公司证件类型", notes = "com.bcxin.Infrastructures.enums.CompanyCertificateType
    private Integer parentCertificateType;
    //总公司证件号码
    private String parentCertificateNumber;
    //总公司法人姓名
    private String parentLegalPersonName;
    //总公司联系电话
    private String parentLegalPersonTelephone;

    //法人或负责人信息
    //法人姓名
    private String legalPersonName;
    //法人手机号码
    private String legalPersonTelephone;
    //法人证件类型", notes = "com.bcxin.Infrastructures.enums.CompanyCertificateType
    private Integer legalPersonCredentialType;
    //法人证件号码
    private String legalPersonCredentialNumber;
    //法人国籍
    private String legalPersonNationality;

    //保安负责人信息
    //保安负责人姓名
    private String securityPersonName;
    //保安负责人手机号码
    private String securityPersonTelephone;
    //保安负责人证件类型", notes = "com.bcxin.Infrastructures.enums.CompanyCertificateType
    private Integer securityPersonCredentialType;
    //保安负责人证件号码
    private String securityPersonCredentialNumber;

    //注册信息
    //注册资本（万元）
    private String registeredCapital;
    //固定资产（万元）
    private String fixedCapital;
    //年营业额（万元）
    private String annualSalesVolume;
    //年利税（万元）
    private String annualProfitTax;
    //证件类型", notes = "com.bcxin.Infrastructures.enums.CompanyCertificateType
    private Integer certificateType;

    //资质信息
    //保安服务许可/保安培训备案证号
    private String servicePermitNumber;
    //发证机关名称
    private String nameOfIssuingAuthority;
    //保安服务许可证首次发证日期或者培训单位的发证日期
    private Date firstIssueServicePermit;
    //保安服务许可证扫描件或者保安培训许可（备案）证扫描件
    private String servicePermitAttachment;
    //批准文号
    private String securityApprovalNumber;
    //服务范围
    private String serviceScope;
    //服务范围
    private Integer serviceScopeInt;
    //人力防范评定等级", notes = "com.bcxin.Infrastructures.enums.SecurityPreparednessRating
    private Integer securityPreparednessRating;
    //武装守护押运评定等级", notes = "com.bcxin.Infrastructures.enums.SecurityArmedRating
    private Integer securityArmedRating;
    //安全技术防范评定等级", notes = "com.bcxin.Infrastructures.enums.SecuritySafetyDefenseRating
    private Integer securitySafetyDefenseRating;
    //是否有风险评估资质
    private Integer isRiskAssessment;
    //培训单位的培训内容
    private String trainContent;

    //自行招用保安员单位
    //拟自招保安员数
    private Integer numberOfSecurityGuards;
    //是否治安保卫重点单位
    private Integer isPublicSecuritySecurity;
    //是否物业企业
    private Integer isPropertyEnterprise;
    //自招保安单位性质
    private String natureOfSelfRecruitedUnits;

    //监管归属
    //监管地区code
    private String placeOfSuperviseCode;
    //监管机构
    private String superviseDepartId;
    //监管机构名称
    private String superviseDepartName;


    private DomainValueSnapshot() {
    }

    public static DomainValueSnapshot create(OrganizationEntity organization) {
        CompanyEntity company = organization.getCompany();

        DomainValueSnapshot valueSnapshot = new DomainValueSnapshot();
        valueSnapshot.setId(organization.getId());
        valueSnapshot.setName(organization.getName());
        valueSnapshot.setStatus(organization.getStatus());
        //注册地址
        if (organization.getPlaceOfRegister() != null) {
            StringBuffer address = new StringBuffer();
            if (organization.getPlaceOfRegister().getProvince() != null) {
                address.append(organization.getPlaceOfRegister().getProvince().getName());
                valueSnapshot.setPlaceOfRegisterProvinceCode(organization.getPlaceOfRegister().getProvince().getCode());
                valueSnapshot.setPlaceOfRegisterProvinceName(organization.getPlaceOfRegister().getProvince().getName());
            }
            if (organization.getPlaceOfRegister().getCity() != null) {
                address.append(organization.getPlaceOfRegister().getCity().getName());
                valueSnapshot.setPlaceOfRegisterCityCode(organization.getPlaceOfRegister().getCity().getCode());
                valueSnapshot.setPlaceOfRegisterCityName(organization.getPlaceOfRegister().getCity().getName());
            }
            if (organization.getPlaceOfRegister().getDistrict() != null) {
                address.append(organization.getPlaceOfRegister().getDistrict().getName());
                valueSnapshot.setPlaceOfRegisterDistrictCode(organization.getPlaceOfRegister().getDistrict().getCode());
                valueSnapshot.setPlaceOfRegisterDistrictName(organization.getPlaceOfRegister().getDistrict().getName());
            }
            valueSnapshot.setRegisteredAddress(address.toString());
            valueSnapshot.setRegisteredAddressDetail(organization.getPlaceOfRegister().getAddress());
        }
        //经营地址
        if (organization.getPlaceOfBusiness() != null) {
            StringBuffer address = new StringBuffer();
            if (organization.getPlaceOfBusiness().getProvince() != null) {
                address.append(organization.getPlaceOfBusiness().getProvince().getName());
                valueSnapshot.setPlaceOfBusinessProvinceCode(organization.getPlaceOfBusiness().getProvince().getCode());
                valueSnapshot.setPlaceOfBusinessProvinceName(organization.getPlaceOfBusiness().getProvince().getName());
            }
            if (organization.getPlaceOfBusiness().getCity() != null) {
                address.append(organization.getPlaceOfBusiness().getCity().getName());
                valueSnapshot.setPlaceOfBusinessCityCode(organization.getPlaceOfBusiness().getCity().getCode());
                valueSnapshot.setPlaceOfBusinessCityName(organization.getPlaceOfBusiness().getCity().getName());
            }
            if (organization.getPlaceOfBusiness().getDistrict() != null) {
                address.append(organization.getPlaceOfBusiness().getDistrict().getName());
                valueSnapshot.setPlaceOfBusinessDistrictCode(organization.getPlaceOfBusiness().getDistrict().getCode());
                valueSnapshot.setPlaceOfBusinessDistrictName(organization.getPlaceOfBusiness().getDistrict().getName());
            }
            valueSnapshot.setOrganizedAddress(address.toString());
            valueSnapshot.setOrganizedAddressDetail(organization.getPlaceOfBusiness().getAddress());
        }
        valueSnapshot.setIndustryCode(organization.getIndustryCode());
        valueSnapshot.setInstitutionalCode(organization.getInstitutionalCode());
        valueSnapshot.setIndustryDetailType(organization.getIndustryDetailType() != null ? organization.getIndustryDetailType().ordinal() : null);
        valueSnapshot.setType(organization.getType() != null ? organization.getType().ordinal() : null);
        valueSnapshot.setTelephone(organization.getTelephone());
        valueSnapshot.setFax(organization.getFax());
        valueSnapshot.setPlaceOfSuperviseCode(organization.getSuperviseRegionCode());
        valueSnapshot.setSuperviseDepartId(organization.getSuperviseDepartId());
        valueSnapshot.setSuperviseDepartName(organization.getSuperviseDepartName());

        if (company != null) {
            valueSnapshot.setOrganizeCode(company.getUnifySocialCreditCode());
            valueSnapshot.setCertificate(company.getUnifySocialCreditCodeFile());
            valueSnapshot.setEconomicType(company.getEconomicType() != null ? company.getEconomicType().ordinal() : null);
            valueSnapshot.setNature(company.getNature() != null ? company.getNature().ordinal() : null);
            valueSnapshot.setParentName(company.getParentName());
            valueSnapshot.setParentCertificateType(company.getParentCertificateType() != null ? company.getParentCertificateType().ordinal() : null);
            valueSnapshot.setParentCertificateNumber(company.getParentCertificateNumber());
            valueSnapshot.setParentLegalPersonName(company.getParentLegalPersonName());
            valueSnapshot.setParentLegalPersonTelephone(company.getParentLegalPersonTelephone());
            valueSnapshot.setLegalPersonName(company.getLegalPersonName());
            valueSnapshot.setLegalPersonTelephone(company.getLegalPersonTelephone());
            valueSnapshot.setLegalPersonCredentialType(company.getLegalPersonCredentialType() != null ? company.getLegalPersonCredentialType().ordinal() : null);
            valueSnapshot.setLegalPersonCredentialNumber(company.getLegalPersonCredentialNumber());
            valueSnapshot.setLegalPersonNationality(company.getLegalPersonNationality());
            valueSnapshot.setSecurityPersonName(company.getSecurityPersonName());
            valueSnapshot.setSecurityPersonTelephone(company.getSecurityPersonTelephone());
            valueSnapshot.setSecurityPersonCredentialType(company.getSecurityPersonCredentialType() != null ? company.getSecurityPersonCredentialType().ordinal() : null);
            valueSnapshot.setSecurityPersonCredentialNumber(company.getSecurityPersonCredentialNumber());
            valueSnapshot.setRegisteredCapital(company.getRegisteredCapital());
            valueSnapshot.setFixedCapital(company.getFixedCapital());
            valueSnapshot.setAnnualSalesVolume(company.getAnnualSalesVolume());
            valueSnapshot.setAnnualProfitTax(company.getAnnualProfitTax());
            valueSnapshot.setCertificateType(company.getCertificateType() != null ? company.getCertificateType().ordinal() : null);
            valueSnapshot.setServicePermitNumber(company.getServicePermitNumber());
            valueSnapshot.setNameOfIssuingAuthority(company.getNameOfIssuingAuthority());
            valueSnapshot.setFirstIssueServicePermit(company.getFirstIssueServicePermit());
            valueSnapshot.setServicePermitAttachment(company.getServicePermitAttachment());
            valueSnapshot.setSecurityApprovalNumber(company.getSecurityApprovalNumber());
            valueSnapshot.setServiceScope(company.getServiceScopeDescription());
            valueSnapshot.setServiceScopeInt(company.getServiceScope());
            valueSnapshot.setSecurityPreparednessRating(company.getSecurityPreparednessRating() != null ? company.getSecurityPreparednessRating().ordinal() : null);
            valueSnapshot.setSecurityArmedRating(company.getSecurityArmedRating() != null ? company.getSecurityArmedRating().ordinal() : null);
            valueSnapshot.setSecuritySafetyDefenseRating(company.getSecuritySafetyDefenseRating() != null ? company.getSecuritySafetyDefenseRating().ordinal() : null);
            valueSnapshot.setIsRiskAssessment(company.getIsRiskAssessment() != null ? company.getIsRiskAssessment() ? 1 : 0 : null);
            valueSnapshot.setTrainContent(company.getTrainContent());
            valueSnapshot.setNumberOfSecurityGuards(company.getNumberOfSecurityGuards());
            valueSnapshot.setIsPublicSecuritySecurity(company.getIsPublicSecuritySecurity() != null ? company.getIsPublicSecuritySecurity() ? 1 : 0 : null);
            valueSnapshot.setIsPropertyEnterprise(company.getIsPropertyEnterprise() != null ? company.getIsPropertyEnterprise() ? 1 : 0 : null);
            valueSnapshot.setNatureOfSelfRecruitedUnits(company.getNatureOfSelfRecruitedUnits());
        }
        return valueSnapshot;
    }

    @Override
    protected PriorityValue getPriority() {
        return PriorityValue.Domain;
    }
}