package com.bcxin.tenant.domain.v5.services.impls;

import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.tenant.domain.v5.entities.TMcNoticeEntity;
import com.bcxin.tenant.domain.v5.repositories.TMcNoticeRepository;
import com.bcxin.tenant.domain.v5.services.TMcNoticeService;
import com.bcxin.tenant.domain.v5.services.commands.CreateMcNoticeCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.stream.Collectors;

@Service
public class TMcNoticeServiceImpl implements TMcNoticeService {
    private final static Logger logger  = LoggerFactory.getLogger(TUserServiceImpl.class);
    private final UnitWork unitWork;
    private final TMcNoticeRepository mcNoticeRepository;

    public TMcNoticeServiceImpl(UnitWork unitWork, TMcNoticeRepository mcNoticeRepository) {
        this.unitWork = unitWork;
        this.mcNoticeRepository = mcNoticeRepository;
    }

    @Override
    public void create(CreateMcNoticeCommand command) {
        this.unitWork.executeTran(() -> {
            Collection<TMcNoticeEntity> entities =
                    command.getItems().stream().map(ii -> {
                        return TMcNoticeEntity.create(
                                ii.getToUserId(),
                                ii.getSummary(),
                                ii.getLinkParams(),
                                ii.getDomainId(),
                                ii.getModule(),
                                ii.getSubjectType(),
                                ii.getContent()
                        );
                    }).collect(Collectors.toList());

            this.mcNoticeRepository.saveAll(entities);
        });
    }
}
