package com.bcxin.tenant.domain.v5.services.commands;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import lombok.Getter;

@Getter
public class UpdateUserCommand extends CommandAbstract {
    private final EmployeeEntity employee;

    public UpdateUserCommand(EmployeeEntity employee) {
        this.employee = employee;
    }

    public static UpdateUserCommand create(EmployeeEntity employee) {
        return new UpdateUserCommand(employee);
    }

    @Override
    public void validate() {
        if (this.getEmployee() == null) {
            throw new ArgumentTenantException("系统代码异常(离职得时候，职员信息不能为空), 清联系管理员");
        }
    }
}
