package com.bcxin.tenant.domain.v5.services.commands;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import lombok.Getter;
import org.springframework.util.CollectionUtils;

import java.util.Collection;

@Getter
public class SyncUserRoleCommand extends CommandAbstract {
    private final String organizationId;
    private final Collection<String> employeeIds;
    private final Collection<String> roleIds;
    private final boolean isFromAdmin;

    public SyncUserRoleCommand(boolean isFromAdmin, String organizationId, Collection<String> employeeIds, Collection<String> roleIds) {
        this.isFromAdmin = isFromAdmin;

        this.organizationId = organizationId;
        this.employeeIds = employeeIds;
        this.roleIds = roleIds;
    }

    public static SyncUserRoleCommand create(boolean isFromAdmin, String organizationId,  Collection<String> employeeIds, Collection<String> roleIds) {
        return new SyncUserRoleCommand(isFromAdmin, organizationId, employeeIds, roleIds);
    }

    @Override
    public void validate() {
        if (CollectionUtils.isEmpty(this.getEmployeeIds())) {
            throw new ArgumentTenantException("要操作的职员列表不能为空");
        }
    }
}
