package com.bcxin.tenant.domain.v5.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Getter
@Setter(AccessLevel.PROTECTED)
@Table(name = "t_user_department_role_set")
@Entity
public class TDepartmentUserEntity extends EntityAbstract {
    @Id
    @Column(name = "id")
    private String id;

    @Column(name = "DEPARTMENTID")
    private String departmentId;

    @Column(name = "USERID")
    private String userId;

    @Column(name = "ROLEID", length = 255)
    private String roleId;

    public void change(String departmentId,String roleId) {
        this.setRoleId(roleId);
        this.setDepartmentId(departmentId);
    }

    protected TDepartmentUserEntity() {
    }

    public static TDepartmentUserEntity create(String departmentId, String userId) {
        TDepartmentUserEntity departmentUser = new TDepartmentUserEntity();
        departmentUser.setId(String.format("T%s-%s", userId, UUIDUtil.getShortUuid()));
        departmentUser.setDepartmentId(departmentId);
        departmentUser.setUserId(userId);

        return departmentUser;
    }

    public void assignRole(String roleId) {
        this.setRoleId(roleId);
    }

    public void assignDepartId(String departmentId) {
        this.setDepartmentId(departmentId);
    }
}
