package com.bcxin.tenant.domain.repository.impls;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.tenant.domain.entities.IdentityUserpasswordEntity;
import com.bcxin.tenant.domain.entities.TenantUserCredentialDetailsEntity;
import com.bcxin.tenant.domain.entities.TenantUserEntity;
import com.bcxin.tenant.domain.repositories.TenantUserRepository;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import javax.transaction.Transactional;
import java.util.Collection;
import java.util.List;

public interface TenantUserJpaRepository extends TenantUserRepository, JpaRepository<TenantUserEntity,String> {

    @Query("select u from TenantUserEntity u join u.selectedCredential sc where sc.number in (?1) and sc.credentialType = ?2")
    TenantUserEntity getByIdNum(String idNum, CredentialType credentialType);

    @Query("select u from IdentityUserpasswordEntity u where u.userName = ?1")
    IdentityUserpasswordEntity getByUserName(String userName);

    TenantUserEntity getByThirdPartyLoginNo(String thirdPartyLoginNo);

    @Query("select u from TenantUserEntity u where u.telephone in (?1)")
    Collection<TenantUserEntity> findAllByTelephones(Collection<String> telephones);

    @Query("select u from TenantUserEntity u where u.id in (?1)")
    Collection<TenantUserEntity> getByIds(Collection<String> ids);

    @Query("select u from TenantUserEntity u join u.credentials k where k.number in (?1)")
    Collection<TenantUserEntity> findAllByNumbers(Collection<String> numbers);

    @Query("select d from TenantUserCredentialDetailsEntity d where d.idnum=?1 and d.tenantUserId is null")
    Collection<TenantUserCredentialDetailsEntity> findNotAssociatedCredentialDetailsByNumbers(String numbers);

   /* @Modifying
    @Transactional
    @Query("update TenantUserCredentialsEntity set tenantUser = ?2 where id in (?1)")
    public void updateCredentialTenantUserId(List<String> ids,TenantUserEntity tenantUserEntity);*/
   @Modifying
   @Transactional
   @Query("update TenantUserCredentialDetailsEntity set tenantUserId = ?2 where idnum in (?1)")
   public void updateCredentialDetailsTenantUserId(Collection<String> idNums,String tenantUserId);

    @Modifying
    @Query("update TenantUserCredentialsEntity set name = ?2 where tenantUser.id = ?1 ")
    public void updateCredentialNameByTenantUserId(String tenantUserId, String name);

}
