package com.bcxin.tenant.domain.repository.customize;

import com.bcxin.tenant.domain.DomainConstraint;
import com.bcxin.tenant.domain.entities.UniqueDataConstraintEntity;
import com.bcxin.tenant.domain.repositories.UniqueDataConstraintRepository;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import java.util.List;

@Repository
public class UniqueDataConstraintJpaRepository implements UniqueDataConstraintRepository {

    private final EntityManager entityManager;
    private final ThreadLocal<List<UniqueDataConstraintEntity>> _uniqueDataConstraintEntity = new ThreadLocal<>();

    public UniqueDataConstraintJpaRepository(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public UniqueDataConstraintEntity create(String category, String combineId) {
        String id = String.format("%s_%s", DomainConstraint.PK_UNIQUE_DATA_CONSTRAINT_COMBINE_ID_PREFIX, combineId);
        UniqueDataConstraintEntity data = UniqueDataConstraintEntity.create(id, category);
        //这个一定要转化为Hibernate的Session否则事务无法执行
        this.entityManager.unwrap(Session.class).persist(data);
        // this.entityManager.persist(data);

        return data;
    }

    @Override
    public void delete(String combineId) {
        String id = String.format("%s_%s", DomainConstraint.PK_UNIQUE_DATA_CONSTRAINT_COMBINE_ID_PREFIX, combineId);
        Session session = this.entityManager.unwrap(Session.class);
        Query query = session.createQuery("delete from UniqueDataConstraintEntity where id=:id");
        query.setParameter("id", id);
        int affectedCount = query.executeUpdate();
    }
}
