/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.repository.impls;

import com.bcxin.tenant.domain.entities.TenantEventEntity;
import com.bcxin.tenant.domain.enums.EventAction;
import com.bcxin.tenant.domain.enums.EventProcessedStatus;
import com.bcxin.tenant.domain.repositories.TenantEventRepository;
import java.util.Collection;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

public interface TenantEventJpaRepository
extends TenantEventRepository,
JpaRepository<TenantEventEntity, String> {
    @Query(value="select t from TenantEventEntity t where t.eventAction in (com.bcxin.tenant.domain.enums.EventAction.OrganizationCreated,com.bcxin.tenant.domain.enums.EventAction.OrganizationEdited,com.bcxin.tenant.domain.enums.EventAction.OrganizationEdited) and t.eventAction= ?1")
    public Collection<TenantEventEntity> getPendingOrganEvents(EventProcessedStatus var1);

    @Query(value="select t from TenantEventEntity t where t.eventAction in (com.bcxin.tenant.domain.enums.EventAction.DepartmentDeleted,com.bcxin.tenant.domain.enums.EventAction.DepartmentCreated,com.bcxin.tenant.domain.enums.EventAction.DepartmentEdited) and t.status= ?1")
    public Collection<TenantEventEntity> getPendingDepartEvents(EventProcessedStatus var1);

    @Query(value="select t from TenantEventEntity t where t.eventAction in (com.bcxin.tenant.domain.enums.EventAction.EmployeeDeleted,com.bcxin.tenant.domain.enums.EventAction.EmployeeCreated,com.bcxin.tenant.domain.enums.EventAction.EmployeeEdited) and t.status= ?1")
    public Collection<TenantEventEntity> getPendingEmployeeEvents(EventProcessedStatus var1);

    @Query(value="select t from TenantEventEntity t where t.version>=?1 and t.mapKey in (?2)")
    public Collection<TenantEventEntity> getEvents(Long var1, Collection<String> var2);

    @Query(value="select t from TenantEventEntity t where t.content=?1 and t.status=com.bcxin.tenant.domain.enums.EventProcessedStatus.Init")
    public Collection<TenantEventEntity> getEventsByUserId(String var1);

    @Query(value="select t from TenantEventEntity t where t.content=?1 and t.eventAction=?2 and t.status in (com.bcxin.tenant.domain.enums.EventProcessedStatus.Init,com.bcxin.tenant.domain.enums.EventProcessedStatus.Processed)")
    public Optional<TenantEventEntity> getPendingByContent(String var1, EventAction var2);

    @Query(value="select t from TenantEventEntity t where t.content=?1")
    public Optional<TenantEventEntity> getByContent(String var1);

    @Query(value="select t from TenantEventEntity t where t.content=?1 and t.status=com.bcxin.tenant.domain.enums.EventProcessedStatus.Init")
    public Optional<TenantEventEntity> getByUserId(String var1);

    @Query(value="select t from TenantEventEntity t where t.content=?1 and t.eventAction=?2 and t.status=com.bcxin.tenant.domain.enums.EventProcessedStatus.Init")
    public Collection<TenantEventEntity> getByUserIdAndAction(String var1, EventAction var2);
}

