package com.bcxin.rest.web.apis.responses;

import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.api.interfaces.tenants.responses.AppRolePermissionResponse;
import io.swagger.annotations.ApiModel;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import java.util.Collection;
import java.util.Collections;

@Getter
@Setter(AccessLevel.PROTECTED)
@ApiModel(description = "职员用户角色权限列表")
public class EmployeeAppRoleGetResponse {
    private final String id;
    private final String name;
    private final String telephone;
    private final String departName;
    private final String occupationType;
    private final String permission;
    //private final Collection<AppRolePermissionResponse.AppResponse> apps;

    public EmployeeAppRoleGetResponse(String id, String name, String telephone,
                                      String departName,
                                      String occupationType,
                                      AppRolePermissionResponse appRolePermissionResponse) {
        this.id = id;
        this.name = name;
        this.telephone = telephone;
        this.departName = departName;
        this.occupationType = occupationType;
        if (appRolePermissionResponse != null) {
            this.permission = appRolePermissionResponse.toString();
            //this.apps = appRolePermissionResponse.getApps();
        } else {
            this.permission = null;
           // this.apps = Collections.EMPTY_LIST;
        }
    }

    public static EmployeeAppRoleGetResponse create(String id, String name, String telephone,
                                      String departName,
                                                    String occupationType,
                                      AppRolePermissionResponse appRolePermissionResponse) {
        return new EmployeeAppRoleGetResponse(id, name, telephone, departName, occupationType, appRolePermissionResponse);
    }
}
