package com.bcxin.rest.web.apis.requests;

import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.api.interfaces.RequestAbstract;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;

@Getter
public class TocUserConfirmCheckStatusRequest extends RequestAbstract {

    @ApiModelProperty(value = "姓名")
    private final String name;

    @ApiModelProperty(value = "证件类型")
    private final CredentialType credentialType;

    @ApiModelProperty(value = "证件号")
    private final String number;

    @ApiModelProperty(value = "人头像")
    private final String headPhoto;

    @ApiModelProperty(value = "身份证人像面")
    private final String frontPhoto;

    @ApiModelProperty(value = "身份证国徽面")
    private final String reversePhoto;

    @ApiModelProperty(value = "身份证地址")
    private final String address;

    @ApiModelProperty(value = "有效期从")
    private final Date validDateFrom;

    @ApiModelProperty(value = "有效期到")
    private final Date validDateTo;

    @ApiModelProperty(value = "手机信息")
    private final String phone;

    @ApiModelProperty(value = "活体头像")
    private final String certificateImage;


    public TocUserConfirmCheckStatusRequest(String name, CredentialType credentialType, String number,
                                            String headPhoto, String frontPhoto, String reversePhoto,
                                            String address, Date validDateFrom, Date validDateTo,
                                            String phone, String certificateImage) {
        this.name = name;
        this.credentialType = credentialType;
        this.number = number;
        this.headPhoto = headPhoto;
        this.frontPhoto = frontPhoto;
        this.reversePhoto = reversePhoto;
        this.address = address;
        this.validDateFrom = validDateFrom;
        this.validDateTo = validDateTo;
        this.phone = phone;
        this.certificateImage = certificateImage;
    }
}
