package com.bcxin.rest.web.apis.requests;

import com.bcxin.api.interfaces.RequestAbstract;
import com.bcxin.api.interfaces.enums.ExternalMemberInviteType;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.lang.NonNull;

import java.util.Collection;

@Data
public class JoinOrganizationAsExternalMemberRequest extends RequestAbstract {

    @NonNull
    @ApiModelProperty(value = "要加入的团体信息;(扫二维码的时候使用;选填)", required = false)
    private final String organizationId;

    @NonNull
    @ApiModelProperty(value = "邀请码、二维码", required = true)
    private String code;

    @NonNull
    @ApiModelProperty(value = "InviteCode=邀请码、QRCode=二维码", required = true)
    private ExternalMemberInviteType inviteType;
}
