package com.bcxin.rest.web.apis.controllers;

import com.bcxin.api.interfaces.rbacs.custom.RbacPermitManagerProvider;
import com.bcxin.api.interfaces.rbacs.custom.request.RbacPermitAuthRequest;
import com.bcxin.api.interfaces.rbacs.custom.request.RbacPermitSearchRequest;
import com.bcxin.api.interfaces.rbacs.custom.response.RbacPermitAppResponse;
import com.bcxin.api.interfaces.rbacs.custom.response.RbacPermitAuthResponse;
import com.bcxin.api.interfaces.rbacs.custom.response.RbacPermitOptionResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

@RestController
@RequestMapping("/tenant/organizations/{organizationId}/permit")
@Api(value = "功能授权管理api", tags = "功能授权管理api")
@AllArgsConstructor
public class PermitManageController extends ControllerAbstract {
    private final RbacPermitManagerProvider permitManagerProvider;

    @ApiOperation(value = "查询组织授权的应用列表和操作项列表，如果有传职员id或角色id，则返回是否授权", response = RbacPermitAppResponse.class)
    @PostMapping("/list")
    public ResponseEntity<List<RbacPermitAppResponse>> findPermitList(@PathVariable String organizationId, @RequestBody RbacPermitSearchRequest request) {
        request.setOrganizationId(organizationId);
        List<RbacPermitAppResponse> list = this.permitManagerProvider.findPermitList(request);
        return this.ok(list);
    }

    @ApiOperation(value = "角色/职员，功能授权", response = String.class)
    @PostMapping("/auth")
    public ResponseEntity<String> authPermitOption(@PathVariable String organizationId, @Valid @RequestBody RbacPermitAuthRequest request) {
        request.setOrganizationId(organizationId);
        this.permitManagerProvider.authPermitOption(request);
        return this.ok("操作成功");
    }


//    @ApiOperation(value = "查询企业授权的应用列表", response = RbacPermitAppResponse.class)
//    @PostMapping("/app/list")
//    public ResponseEntity<List<RbacPermitAppResponse>> findOrgAppList(@PathVariable String organizationId, RbacPermitSearchRequest request) {
//        request.setOrganizationId(organizationId);
//        List<RbacPermitAppResponse> list = this.permitManagerProvider.findOrgAppList(organizationId);
//        return this.ok(list);
//    }
//
//
//    @ApiOperation(value = "查询应用的操作项列表", response = RbacPermitOptionResponse.class)
//    @PostMapping("/{appId}/option/list")
//    public ResponseEntity<List<RbacPermitOptionResponse>> findAppOptionList(@PathVariable String organizationId, @PathVariable Long appId) {
//        List<RbacPermitOptionResponse> list = this.permitManagerProvider.findAppOptionList(appId);
//        return this.ok(list);
//    }
//    @ApiOperation(value = "根据职员id，查询该职员的功能授权", response = RbacPermitAuthResponse.class)
//    @PostMapping("/get/employee/{employeeId}")
//    public ResponseEntity<RbacPermitAuthResponse> getEmployeeAuthByEmployeeId(@PathVariable String organizationId, @PathVariable String employeeId) {
//        return this.ok(this.permitManagerProvider.getEmployeeAuthByEmployeeId(organizationId, employeeId));
//    }
//
//    @ApiOperation(value = "根据角色id，查询该角色的功能授权", response = RbacPermitAuthResponse.class)
//    @PostMapping("/get/role/{roleId}")
//    public ResponseEntity<RbacPermitAuthResponse> getRoleAuthByRoleId(@PathVariable String organizationId, @PathVariable Long roleId) {
//        return this.ok(this.permitManagerProvider.getRoleAuthByRoleId(organizationId, roleId));
//    }
//
//    @ApiOperation(value = "根据职员id，查询该职员所有的功能授权，包括个人和角色授权", response = RbacPermitAuthResponse.class)
//    @PostMapping("/get/all/{employeeId}")
//    public ResponseEntity<RbacPermitAuthResponse> getAllAuthByEmployeeId(@PathVariable String organizationId, @PathVariable String employeeId) {
//        return this.ok(this.permitManagerProvider.getAllAuthByEmployeeId(organizationId, employeeId));
//    }
}
