package com.bcxin.rest.web.apis.controllers;

import com.bcxin.Infrastructures.Pageable;
import com.bcxin.api.interfaces.tenants.EmployeeRecordRpcProvider;
import com.bcxin.api.interfaces.tenants.criterias.EmployeeRecordCriteria;
import com.bcxin.api.interfaces.tenants.responses.EmployeeRecordResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;


@RestController
@RequestMapping("/tenant/organizations/{organizationId}/employee-records")
public class EmployeeRecordController extends ControllerAbstract {
    private final EmployeeRecordRpcProvider employeeRecordRpcProvider;

    public EmployeeRecordController(EmployeeRecordRpcProvider employeeRecordRpcProvider) {
        this.employeeRecordRpcProvider = employeeRecordRpcProvider;
    }

    @Operation(
            summary = "搜索入离职记录", description = "搜索入离职记录",
            responses = {
                    @ApiResponse(responseCode = "200", description = "成功返回入离职记录信息.")
            },
            parameters = {
                    @Parameter(in = ParameterIn.PATH, required = true, name = "organizationId",
                            description = "当前企业的组织Id")
            }
    )
    @PostMapping
    public ResponseEntity search(@PathVariable String organizationId,
                                 @RequestBody EmployeeRecordCriteria criteria) {
        Pageable<EmployeeRecordResponse> recordResponsePageable
                = this.employeeRecordRpcProvider.search(organizationId, criteria);

        return this.ok(recordResponsePageable);
    }
}
