package com.bcxin.rest.web.apis.controllers;

import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.rest.web.apis.ResponseBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public abstract class ControllerAbstract {
    protected <T> ResponseEntity<T> ok(T data) {
        return ResponseBuilder.build(HttpStatus.OK, data);
    }

    protected <T> ResponseEntity<T> ok() {
        return ResponseBuilder.build(HttpStatus.OK, null);
    }

    protected ResponseEntity notFound() {
        return ResponseBuilder.build(HttpStatus.NOT_FOUND, null);
    }

    protected ResponseEntity status(HttpStatus status,String msg) {
        return ResponseBuilder.build(status, null,msg,null);
    }

    protected ResponseEntity error(String msg) {
        return ResponseBuilder.build(HttpStatus.BAD_REQUEST, null,msg,null);
    }

    protected ResponseEntity badRequest(String msg) {
        return ResponseBuilder.build(HttpStatus.BAD_REQUEST, null);
    }

    protected <T> ResponseEntity<T> badRequest(T data) {
        return ResponseBuilder.build(HttpStatus.BAD_REQUEST, data);
    }

    protected ResponseEntity badRequest(Throwable ex) {
        return ResponseEntity.badRequest().build();
    }

    protected String getSelectedEmployeeId() {
        if (TenantContext.getInstance().getUserContext().get() == null) {
            return null;
        }

        return TenantContext.getInstance().getUserContext().get().getEmployeeId();
    }

    protected boolean isCurrentOrgDomainAdmin() {
        if (TenantContext.getInstance().getUserContext().get() == null) {
            return false;
        }

        return TenantContext.getInstance().getUserContext().get().isMaster();
    }

    protected boolean isCurrentOrgDepartAdmin() {
        if (TenantContext.getInstance().getUserContext().get() == null) {
            return false;
        }

        return TenantContext.getInstance().getUserContext().get().isDepartAdmin();
    }

    protected boolean isCurrentOrgDomainOrDepartAdmin() {
        return this.isCurrentOrgDomainAdmin() || this.isCurrentOrgDepartAdmin();
    }

    protected String getSelectedOrganId() {
        if (TenantContext.getInstance().getUserContext().get() == null) {
            return null;
        }

        return TenantContext.getInstance().getUserContext().get().getOrganId();
    }

    protected String getCurrentUserId() {
        if (TenantContext.getInstance().getUserContext().get() == null) {
            return null;
        }

        return TenantContext.getInstance().getUserContext().get().getId();
    }
}
