package com.bcxin.rest.web.apis.controllers;

import cn.hutool.core.util.StrUtil;
import com.bcxin.Infrastructures.Pageable;
import com.bcxin.api.interfaces.identities.IdentityRpcProvider;
import com.bcxin.api.interfaces.identities.requests.ThirdPartyCommonTokenRequest;
import com.bcxin.api.interfaces.identities.responses.ThirdPartyCommonTokenResponse;
import com.bcxin.api.interfaces.tenants.EmployeeRpcProvider;
import com.bcxin.api.interfaces.tenants.requests.tenantUsers.IMContactCriteria;
import com.bcxin.api.interfaces.tenants.responses.ImContactResponse;
import io.swagger.annotations.Api;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 通用的控制类
 */
@Api("通用的接口")
@RestController
@RequestMapping("/tenant/common")
public class CommonController extends ControllerAbstract {

    private final EmployeeRpcProvider employeeRpcProvider;
    private final IdentityRpcProvider identityRpcProvider;

    public CommonController(EmployeeRpcProvider employeeRpcProvider, IdentityRpcProvider identityRpcProvider){
        this.employeeRpcProvider = employeeRpcProvider;
        this.identityRpcProvider = identityRpcProvider;
    }

    @PostMapping("/contacts/search")
    public ResponseEntity contactSearch(@RequestBody IMContactCriteria request) {
        if(StrUtil.isEmpty(request.getKeyword())){
            return this.error("请输入要搜索的人员信息!");
        }
        Pageable<ImContactResponse> responses = this.employeeRpcProvider.contactSearch(request);

        return this.ok(responses);
    }

    @PostMapping("/third-party/token")
    public ResponseEntity getThirdPartyAccessToken(@RequestBody ThirdPartyCommonTokenRequest request) {
        ThirdPartyCommonTokenResponse accessToken =
                this.identityRpcProvider.getAccessToken(request);

        return this.ok(accessToken);
    }
}
