package com.bcxin.Infrastructures.components;

import com.bcxin.Infrastructures.exceptions.NotAllowedTenantException;
import org.springframework.stereotype.Component;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

public interface FileValidator {
    void execute(File file);

    @Component
    public static class FileValidatorImpl implements FileValidator
    {
        private static final Collection<String> notAllowedFileExtenions = new ArrayList<>();
        static {
            notAllowedFileExtenions.add(".sh");
            notAllowedFileExtenions.add(".jsp");
            notAllowedFileExtenions.add(".asp");
            notAllowedFileExtenions.add(".php");
            notAllowedFileExtenions.add(".bat");
            notAllowedFileExtenions.add(".js");
        }

        @Override
        public void execute(File file) {
            if(notAllowedFileExtenions.stream().anyMatch(ix->file.getName().endsWith(ix))) {
                throw new NotAllowedTenantException("不允许上传的文件格式");
            }
        }
    }
}
