package com.bcxin.infrastructure.offices.utils;

import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import org.apache.poi.ss.usermodel.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EmployeeCellWriteHandler implements CellWriteHandler {

    private Integer authIndex;
    private Integer checkIndex;
    private Map<String,CellStyle> colorStyleMap;

    private CellStyle getCellStyle(String key){
        return colorStyleMap.get(key);
    }

    private void setColorStyleMap(Workbook workbook){
        //证件核验状态：未提交（红）、已提交（黄）、已核验（绿）
        //实名认证状态：未认证（黑）、认证中（黄）、认证失败（红）、已认证（绿）
        if(colorStyleMap == null) {
            colorStyleMap = new HashMap<>();
            CellStyle redCellStyle = workbook.createCellStyle();
            Font redFont = workbook.createFont();
            redFont.setColor(Font.COLOR_RED);
            redCellStyle.setFont(redFont);
            colorStyleMap.put("未提交", redCellStyle);
            colorStyleMap.put("认证失败", redCellStyle);
            CellStyle yellowCellStyle = workbook.createCellStyle();
            Font yellowFont = workbook.createFont();
            yellowFont.setColor(IndexedColors.ORANGE.index);
            yellowCellStyle.setFont(yellowFont);
            colorStyleMap.put("已提交", yellowCellStyle);
            colorStyleMap.put("认证中", yellowCellStyle);
            CellStyle greenCellStyle = workbook.createCellStyle();
            Font greenFont = workbook.createFont();
            greenFont.setColor(IndexedColors.GREEN.index);
            greenCellStyle.setFont(greenFont);
            colorStyleMap.put("已核验", greenCellStyle);
            colorStyleMap.put("已认证", greenCellStyle);
        }
    }

    @Override
    public void afterCellDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, List<WriteCellData<?>> cellDataList, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
        this.setColorStyleMap(writeSheetHolder.getSheet().getWorkbook());
        // 这里可以对cell进行任何操作  实名认证状态
        if(isHead) {
            if ("证件核验状态".equals(cell.getStringCellValue())) {
                checkIndex = cell.getColumnIndex();
                return;
            }
            if ("实名认证状态".equals(cell.getStringCellValue())) {
                authIndex = cell.getColumnIndex();
                return;
            }
        }else{
            if(authIndex != null && cell.getColumnIndex() == authIndex.intValue()){
                if(getCellStyle(cell.getStringCellValue()) != null){
                    cell.setCellStyle(getCellStyle(cell.getStringCellValue()));
                }
            }
            if(checkIndex != null && cell.getColumnIndex() == checkIndex.intValue()){
                if(getCellStyle(cell.getStringCellValue()) != null){
                    cell.setCellStyle(getCellStyle(cell.getStringCellValue()));
                }
            }
        }
    }

}
